/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Quaternionf
implements Externalizable,
Quaternionfc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternionf() {
        this.w = 1.0f;
    }

    public Quaternionf(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternionf(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = 1.0f;
    }

    public Quaternionf(Quaternionf source) {
        MemUtil.INSTANCE.copy(source, this);
    }

    public Quaternionf(AxisAngle4f axisAngle) {
        float sin = (float)Math.sin((double)axisAngle.angle * 0.5);
        float cos = (float)Math.cosFromSin(sin, (double)axisAngle.angle * 0.5);
        this.x = axisAngle.x * sin;
        this.y = axisAngle.y * sin;
        this.z = axisAngle.z * sin;
        this.w = cos;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public Quaternionf normalize() {
        float invNorm = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w));
        this.x *= invNorm;
        this.y *= invNorm;
        this.z *= invNorm;
        this.w *= invNorm;
        return this;
    }

    public Quaternionf normalize(Quaternionf dest) {
        float invNorm = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w));
        dest.x = this.x * invNorm;
        dest.y = this.y * invNorm;
        dest.z = this.z * invNorm;
        dest.w = this.w * invNorm;
        return dest;
    }

    public Quaternionf add(float x, float y, float z, float w) {
        return this.add(x, y, z, w, this);
    }

    public Quaternionf add(float x, float y, float z, float w, Quaternionf dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        dest.w = this.w + w;
        return dest;
    }

    public Quaternionf add(Quaternionfc q2) {
        this.x += q2.x();
        this.y += q2.y();
        this.z += q2.z();
        this.w += q2.w();
        return this;
    }

    public Quaternionf add(Quaternionfc q2, Quaternionf dest) {
        dest.x = this.x + q2.x();
        dest.y = this.y + q2.y();
        dest.z = this.z + q2.z();
        dest.w = this.w + q2.w();
        return dest;
    }

    public float dot(Quaternionf otherQuat) {
        return this.x * otherQuat.x + this.y * otherQuat.y + this.z * otherQuat.z + this.w * otherQuat.w;
    }

    public float angle() {
        float angle = (float)(2.0 * Math.acos(this.w));
        return (float)((double)angle <= java.lang.Math.PI ? (double)angle : java.lang.Math.PI * 2 - (double)angle);
    }

    public Matrix3f get(Matrix3f dest) {
        return dest.set(this);
    }

    public Matrix3d get(Matrix3d dest) {
        return dest.set(this);
    }

    public Matrix4f get(Matrix4f dest) {
        return dest.set(this);
    }

    public Matrix4d get(Matrix4d dest) {
        return dest.set(this);
    }

    public Matrix4x3f get(Matrix4x3f dest) {
        return dest.set(this);
    }

    public Matrix4x3d get(Matrix4x3d dest) {
        return dest.set(this);
    }

    public AxisAngle4f get(AxisAngle4f dest) {
        float x = this.x;
        float y = this.y;
        float z = this.z;
        float w = this.w;
        if (w > 1.0f) {
            float invNorm = (float)(1.0 / Math.sqrt(x * x + y * y + z * z + w * w));
            x *= invNorm;
            y *= invNorm;
            z *= invNorm;
            w *= invNorm;
        }
        dest.angle = (float)(2.0 * Math.acos(w));
        float s = (float)Math.sqrt(1.0 - (double)(w * w));
        if (s < 0.001f) {
            dest.x = x;
            dest.y = y;
            dest.z = z;
        } else {
            s = 1.0f / s;
            dest.x = x * s;
            dest.y = y * s;
            dest.z = z * s;
        }
        return dest;
    }

    public Quaterniond get(Quaterniond dest) {
        return dest.set(this);
    }

    public Quaternionf get(Quaternionf dest) {
        return dest.set(this);
    }

    public ByteBuffer getAsMatrix3f(ByteBuffer dest) {
        MemUtil.INSTANCE.putMatrix3f(this, dest.position(), dest);
        return dest;
    }

    public FloatBuffer getAsMatrix3f(FloatBuffer dest) {
        MemUtil.INSTANCE.putMatrix3f(this, dest.position(), dest);
        return dest;
    }

    public ByteBuffer getAsMatrix4f(ByteBuffer dest) {
        MemUtil.INSTANCE.putMatrix4f(this, dest.position(), dest);
        return dest;
    }

    public FloatBuffer getAsMatrix4f(FloatBuffer dest) {
        MemUtil.INSTANCE.putMatrix4f(this, dest.position(), dest);
        return dest;
    }

    public ByteBuffer getAsMatrix4x3f(ByteBuffer dest) {
        MemUtil.INSTANCE.putMatrix4x3f(this, dest.position(), dest);
        return dest;
    }

    public FloatBuffer getAsMatrix4x3f(FloatBuffer dest) {
        MemUtil.INSTANCE.putMatrix4x3f(this, dest.position(), dest);
        return dest;
    }

    public Quaternionf set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternionf set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Quaternionf set(Quaternionfc q) {
        if (q instanceof Quaternionf) {
            MemUtil.INSTANCE.copy((Quaternionf)q, this);
        } else {
            this.x = q.x();
            this.y = q.y();
            this.z = q.z();
            this.w = q.w();
        }
        return this;
    }

    public Quaternionf set(AxisAngle4f axisAngle) {
        return this.setAngleAxis(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Quaternionf set(AxisAngle4d axisAngle) {
        return this.setAngleAxis(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Quaternionf setAngleAxis(float angle, float x, float y, float z) {
        float s = (float)Math.sin((double)angle * 0.5);
        this.x = x * s;
        this.y = y * s;
        this.z = z * s;
        this.w = (float)Math.cosFromSin(s, (double)angle * 0.5);
        return this;
    }

    public Quaternionf setAngleAxis(double angle, double x, double y, double z) {
        double s = Math.sin(angle * 0.5);
        this.x = (float)(x * s);
        this.y = (float)(y * s);
        this.z = (float)(z * s);
        this.w = (float)Math.cosFromSin(s, angle * 0.5);
        return this;
    }

    public Quaternionf rotationAxis(AxisAngle4f axisAngle) {
        return this.rotationAxis(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Quaternionf rotationAxis(float angle, float axisX, float axisY, float axisZ) {
        float hangle = angle / 2.0f;
        float sinAngle = (float)Math.sin(hangle);
        float invVLength = (float)(1.0 / Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ));
        this.x = axisX * invVLength * sinAngle;
        this.y = axisY * invVLength * sinAngle;
        this.z = axisZ * invVLength * sinAngle;
        this.w = (float)Math.cosFromSin(sinAngle, hangle);
        return this;
    }

    public Quaternionf rotationAxis(float angle, Vector3fc axis) {
        return this.rotationAxis(angle, axis.x(), axis.y(), axis.z());
    }

    public Quaternionf rotation(float angleX, float angleY, float angleZ) {
        double s;
        double thetaX = (double)angleX * 0.5;
        double thetaY = (double)angleY * 0.5;
        double thetaZ = (double)angleZ * 0.5;
        double thetaMagSq = thetaX * thetaX + thetaY * thetaY + thetaZ * thetaZ;
        if (thetaMagSq * thetaMagSq / 24.0 < (double)1.0E-8f) {
            this.w = (float)(1.0 - thetaMagSq / 2.0);
            s = 1.0 - thetaMagSq / 6.0;
        } else {
            double thetaMag = Math.sqrt(thetaMagSq);
            double sin = Math.sin(thetaMag);
            s = sin / thetaMag;
            this.w = (float)Math.cosFromSin(sin, thetaMag);
        }
        this.x = (float)(thetaX * s);
        this.y = (float)(thetaY * s);
        this.z = (float)(thetaZ * s);
        return this;
    }

    public Quaternionf rotationX(float angle) {
        float cos;
        float sin = (float)Math.sin((double)angle * 0.5);
        this.w = cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        this.x = sin;
        this.y = 0.0f;
        this.z = 0.0f;
        return this;
    }

    public Quaternionf rotationY(float angle) {
        float cos;
        float sin = (float)Math.sin((double)angle * 0.5);
        this.w = cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        this.x = 0.0f;
        this.y = sin;
        this.z = 0.0f;
        return this;
    }

    public Quaternionf rotationZ(float angle) {
        float cos;
        float sin = (float)Math.sin((double)angle * 0.5);
        this.w = cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = sin;
        return this;
    }

    private void setFromUnnormalized(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float nm00 = m00;
        float nm01 = m01;
        float nm02 = m02;
        float nm10 = m10;
        float nm11 = m11;
        float nm12 = m12;
        float nm20 = m20;
        float nm21 = m21;
        float nm22 = m22;
        float lenX = (float)(1.0 / Math.sqrt(m00 * m00 + m01 * m01 + m02 * m02));
        float lenY = (float)(1.0 / Math.sqrt(m10 * m10 + m11 * m11 + m12 * m12));
        float lenZ = (float)(1.0 / Math.sqrt(m20 * m20 + m21 * m21 + m22 * m22));
        this.setFromNormalized(nm00 *= lenX, nm01 *= lenX, nm02 *= lenX, nm10 *= lenY, nm11 *= lenY, nm12 *= lenY, nm20 *= lenZ, nm21 *= lenZ, nm22 *= lenZ);
    }

    private void setFromNormalized(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float tr = m00 + m11 + m22;
        if (tr >= 0.0f) {
            float t = (float)Math.sqrt(tr + 1.0f);
            this.w = t * 0.5f;
            t = 0.5f / t;
            this.x = (m12 - m21) * t;
            this.y = (m20 - m02) * t;
            this.z = (m01 - m10) * t;
        } else if (m00 >= m11 && m00 >= m22) {
            float t = (float)Math.sqrt((double)(m00 - (m11 + m22)) + 1.0);
            this.x = t * 0.5f;
            t = 0.5f / t;
            this.y = (m10 + m01) * t;
            this.z = (m02 + m20) * t;
            this.w = (m12 - m21) * t;
        } else if (m11 > m22) {
            float t = (float)Math.sqrt((double)(m11 - (m22 + m00)) + 1.0);
            this.y = t * 0.5f;
            t = 0.5f / t;
            this.z = (m21 + m12) * t;
            this.x = (m10 + m01) * t;
            this.w = (m20 - m02) * t;
        } else {
            float t = (float)Math.sqrt((double)(m22 - (m00 + m11)) + 1.0);
            this.z = t * 0.5f;
            t = 0.5f / t;
            this.x = (m02 + m20) * t;
            this.y = (m21 + m12) * t;
            this.w = (m01 - m10) * t;
        }
    }

    private void setFromUnnormalized(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double nm00 = m00;
        double nm01 = m01;
        double nm02 = m02;
        double nm10 = m10;
        double nm11 = m11;
        double nm12 = m12;
        double nm20 = m20;
        double nm21 = m21;
        double nm22 = m22;
        double lenX = 1.0 / Math.sqrt(m00 * m00 + m01 * m01 + m02 * m02);
        double lenY = 1.0 / Math.sqrt(m10 * m10 + m11 * m11 + m12 * m12);
        double lenZ = 1.0 / Math.sqrt(m20 * m20 + m21 * m21 + m22 * m22);
        this.setFromNormalized(nm00 *= lenX, nm01 *= lenX, nm02 *= lenX, nm10 *= lenY, nm11 *= lenY, nm12 *= lenY, nm20 *= lenZ, nm21 *= lenZ, nm22 *= lenZ);
    }

    private void setFromNormalized(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double tr = m00 + m11 + m22;
        if (tr >= 0.0) {
            double t = Math.sqrt(tr + 1.0);
            this.w = (float)(t * 0.5);
            t = 0.5 / t;
            this.x = (float)((m12 - m21) * t);
            this.y = (float)((m20 - m02) * t);
            this.z = (float)((m01 - m10) * t);
        } else if (m00 >= m11 && m00 >= m22) {
            double t = Math.sqrt(m00 - (m11 + m22) + 1.0);
            this.x = (float)(t * 0.5);
            t = 0.5 / t;
            this.y = (float)((m10 + m01) * t);
            this.z = (float)((m02 + m20) * t);
            this.w = (float)((m12 - m21) * t);
        } else if (m11 > m22) {
            double t = (float)Math.sqrt(m11 - (m22 + m00) + 1.0);
            this.y = (float)(t * 0.5);
            t = 0.5 / t;
            this.z = (float)((m21 + m12) * t);
            this.x = (float)((m10 + m01) * t);
            this.w = (float)((m20 - m02) * t);
        } else {
            double t = (float)Math.sqrt(m22 - (m00 + m11) + 1.0);
            this.z = (float)(t * 0.5);
            t = 0.5 / t;
            this.x = (float)((m02 + m20) * t);
            this.y = (float)((m21 + m12) * t);
            this.w = (float)((m01 - m10) * t);
        }
    }

    public Quaternionf setFromUnnormalized(Matrix4fc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4x3fc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4x3dc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4fc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4x3fc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4x3dc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4dc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4dc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix3fc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix3fc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix3dc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix3dc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaternionf fromAxisAngleRad(Vector3fc axis, float angle) {
        return this.fromAxisAngleRad(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternionf fromAxisAngleRad(float axisX, float axisY, float axisZ, float angle) {
        float hangle = angle / 2.0f;
        float sinAngle = (float)Math.sin(hangle);
        float vLength = (float)Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        this.x = axisX / vLength * sinAngle;
        this.y = axisY / vLength * sinAngle;
        this.z = axisZ / vLength * sinAngle;
        this.w = (float)Math.cosFromSin(sinAngle, hangle);
        return this;
    }

    public Quaternionf fromAxisAngleDeg(Vector3fc axis, float angle) {
        return this.fromAxisAngleRad(axis.x(), axis.y(), axis.z(), (float)Math.toRadians(angle));
    }

    public Quaternionf fromAxisAngleDeg(float axisX, float axisY, float axisZ, float angle) {
        return this.fromAxisAngleRad(axisX, axisY, axisZ, (float)Math.toRadians(angle));
    }

    public Quaternionf mul(Quaternionfc q) {
        return this.mul(q, this);
    }

    public Quaternionf mul(Quaternionfc q, Quaternionf dest) {
        dest.set(this.w * q.x() + this.x * q.w() + this.y * q.z() - this.z * q.y(), this.w * q.y() - this.x * q.z() + this.y * q.w() + this.z * q.x(), this.w * q.z() + this.x * q.y() - this.y * q.x() + this.z * q.w(), this.w * q.w() - this.x * q.x() - this.y * q.y() - this.z * q.z());
        return dest;
    }

    public Quaternionf mul(float qx, float qy, float qz, float qw) {
        this.set(this.w * qx + this.x * qw + this.y * qz - this.z * qy, this.w * qy - this.x * qz + this.y * qw + this.z * qx, this.w * qz + this.x * qy - this.y * qx + this.z * qw, this.w * qw - this.x * qx - this.y * qy - this.z * qz);
        return this;
    }

    public Quaternionf mul(float qx, float qy, float qz, float qw, Quaternionf dest) {
        dest.set(this.w * qx + this.x * qw + this.y * qz - this.z * qy, this.w * qy - this.x * qz + this.y * qw + this.z * qx, this.w * qz + this.x * qy - this.y * qx + this.z * qw, this.w * qw - this.x * qx - this.y * qy - this.z * qz);
        return dest;
    }

    public Quaternionf premul(Quaternionfc q) {
        return this.premul(q, this);
    }

    public Quaternionf premul(Quaternionfc q, Quaternionf dest) {
        dest.set(q.w() * this.x + q.x() * this.w + q.y() * this.z - q.z() * this.y, q.w() * this.y - q.x() * this.z + q.y() * this.w + q.z() * this.x, q.w() * this.z + q.x() * this.y - q.y() * this.x + q.z() * this.w, q.w() * this.w - q.x() * this.x - q.y() * this.y - q.z() * this.z);
        return dest;
    }

    public Quaternionf premul(float qx, float qy, float qz, float qw) {
        return this.premul(qx, qy, qz, qw, this);
    }

    public Quaternionf premul(float qx, float qy, float qz, float qw, Quaternionf dest) {
        dest.set(qw * this.x + qx * this.w + qy * this.z - qz * this.y, qw * this.y - qx * this.z + qy * this.w + qz * this.x, qw * this.z + qx * this.y - qy * this.x + qz * this.w, qw * this.w - qx * this.x - qy * this.y - qz * this.z);
        return dest;
    }

    public Vector3f transform(Vector3f vec) {
        return this.transform(vec.x, vec.y, vec.z, vec);
    }

    public Vector4f transform(Vector4f vec) {
        return this.transform(vec, vec);
    }

    public Vector3f transform(Vector3fc vec, Vector3f dest) {
        return this.transform(vec.x(), vec.y(), vec.z(), dest);
    }

    public Vector3d transform(Vector3dc vec, Vector3d dest) {
        return this.transform(vec.x(), vec.y(), vec.z(), dest);
    }

    public Vector3f transform(float x, float y, float z, Vector3f dest) {
        float w2 = this.w * this.w;
        float x2 = this.x * this.x;
        float y2 = this.y * this.y;
        float z2 = this.z * this.z;
        float zw = this.z * this.w;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float yw = this.y * this.w;
        float yz = this.y * this.z;
        float xw = this.x * this.w;
        float m00 = w2 + x2 - z2 - y2;
        float m01 = xy + zw + zw + xy;
        float m02 = xz - yw + xz - yw;
        float m10 = -zw + xy - zw + xy;
        float m11 = y2 - z2 + w2 - x2;
        float m12 = yz + yz + xw + xw;
        float m20 = yw + xz + xz + yw;
        float m21 = yz + yz - xw - xw;
        float m22 = z2 - y2 - x2 + w2;
        dest.x = m00 * x + m10 * y + m20 * z;
        dest.y = m01 * x + m11 * y + m21 * z;
        dest.z = m02 * x + m12 * y + m22 * z;
        return dest;
    }

    public Vector3d transform(double x, double y, double z, Vector3d dest) {
        float w2 = this.w * this.w;
        float x2 = this.x * this.x;
        float y2 = this.y * this.y;
        float z2 = this.z * this.z;
        float zw = this.z * this.w;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float yw = this.y * this.w;
        float yz = this.y * this.z;
        float xw = this.x * this.w;
        float m00 = w2 + x2 - z2 - y2;
        float m01 = xy + zw + zw + xy;
        float m02 = xz - yw + xz - yw;
        float m10 = -zw + xy - zw + xy;
        float m11 = y2 - z2 + w2 - x2;
        float m12 = yz + yz + xw + xw;
        float m20 = yw + xz + xz + yw;
        float m21 = yz + yz - xw - xw;
        float m22 = z2 - y2 - x2 + w2;
        dest.x = (double)m00 * x + (double)m10 * y + (double)m20 * z;
        dest.y = (double)m01 * x + (double)m11 * y + (double)m21 * z;
        dest.z = (double)m02 * x + (double)m12 * y + (double)m22 * z;
        return dest;
    }

    public Vector4f transform(Vector4fc vec, Vector4f dest) {
        return this.transform(vec.x(), vec.y(), vec.z(), dest);
    }

    public Vector4f transform(float x, float y, float z, Vector4f dest) {
        float w2 = this.w * this.w;
        float x2 = this.x * this.x;
        float y2 = this.y * this.y;
        float z2 = this.z * this.z;
        float zw = this.z * this.w;
        float xy = this.x * this.y;
        float xz = this.x * this.z;
        float yw = this.y * this.w;
        float yz = this.y * this.z;
        float xw = this.x * this.w;
        float m00 = w2 + x2 - z2 - y2;
        float m01 = xy + zw + zw + xy;
        float m02 = xz - yw + xz - yw;
        float m10 = -zw + xy - zw + xy;
        float m11 = y2 - z2 + w2 - x2;
        float m12 = yz + yz + xw + xw;
        float m20 = yw + xz + xz + yw;
        float m21 = yz + yz - xw - xw;
        float m22 = z2 - y2 - x2 + w2;
        dest.x = m00 * x + m10 * y + m20 * z;
        dest.y = m01 * x + m11 * y + m21 * z;
        dest.z = m02 * x + m12 * y + m22 * z;
        return dest;
    }

    public Quaternionf invert(Quaternionf dest) {
        float invNorm = 1.0f / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        dest.x = -this.x * invNorm;
        dest.y = -this.y * invNorm;
        dest.z = -this.z * invNorm;
        dest.w = this.w * invNorm;
        return dest;
    }

    public Quaternionf invert() {
        return this.invert(this);
    }

    public Quaternionf div(Quaternionfc b, Quaternionf dest) {
        float invNorm = 1.0f / (b.x() * b.x() + b.y() * b.y() + b.z() * b.z() + b.w() * b.w());
        float x = -b.x() * invNorm;
        float y = -b.y() * invNorm;
        float z = -b.z() * invNorm;
        float w = b.w() * invNorm;
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaternionf div(Quaternionfc b) {
        return this.div(b, this);
    }

    public Quaternionf conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Quaternionf conjugate(Quaternionf dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = this.w;
        return dest;
    }

    public Quaternionf identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    public Quaternionf rotateXYZ(float angleX, float angleY, float angleZ) {
        return this.rotateXYZ(angleX, angleY, angleZ, this);
    }

    public Quaternionf rotateXYZ(float angleX, float angleY, float angleZ, Quaternionf dest) {
        float sx = (float)Math.sin((double)angleX * 0.5);
        float cx = (float)Math.cosFromSin(sx, (double)angleX * 0.5);
        float sy = (float)Math.sin((double)angleY * 0.5);
        float cy = (float)Math.cosFromSin(sy, (double)angleY * 0.5);
        float sz = (float)Math.sin((double)angleZ * 0.5);
        float cz = (float)Math.cosFromSin(sz, (double)angleZ * 0.5);
        float cycz = cy * cz;
        float sysz = sy * sz;
        float sycz = sy * cz;
        float cysz = cy * sz;
        float w = cx * cycz - sx * sysz;
        float x = sx * cycz + cx * sysz;
        float y = cx * sycz - sx * cysz;
        float z = cx * cysz + sx * sycz;
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaternionf rotateZYX(float angleZ, float angleY, float angleX) {
        return this.rotateZYX(angleZ, angleY, angleX, this);
    }

    public Quaternionf rotateZYX(float angleZ, float angleY, float angleX, Quaternionf dest) {
        float sx = (float)Math.sin((double)angleX * 0.5);
        float cx = (float)Math.cosFromSin(sx, (double)angleX * 0.5);
        float sy = (float)Math.sin((double)angleY * 0.5);
        float cy = (float)Math.cosFromSin(sy, (double)angleY * 0.5);
        float sz = (float)Math.sin((double)angleZ * 0.5);
        float cz = (float)Math.cosFromSin(sz, (double)angleZ * 0.5);
        float cycz = cy * cz;
        float sysz = sy * sz;
        float sycz = sy * cz;
        float cysz = cy * sz;
        float w = cx * cycz + sx * sysz;
        float x = sx * cycz - cx * sysz;
        float y = cx * sycz + sx * cysz;
        float z = cx * cysz - sx * sycz;
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaternionf rotateYXZ(float angleZ, float angleY, float angleX) {
        return this.rotateYXZ(angleZ, angleY, angleX, this);
    }

    public Quaternionf rotateYXZ(float angleY, float angleX, float angleZ, Quaternionf dest) {
        float sx = (float)Math.sin((double)angleX * 0.5);
        float cx = (float)Math.cosFromSin(sx, (double)angleX * 0.5);
        float sy = (float)Math.sin((double)angleY * 0.5);
        float cy = (float)Math.cosFromSin(sy, (double)angleY * 0.5);
        float sz = (float)Math.sin((double)angleZ * 0.5);
        float cz = (float)Math.cosFromSin(sz, (double)angleZ * 0.5);
        float yx = cy * sx;
        float yy = sy * cx;
        float yz = sy * sx;
        float yw = cy * cx;
        float x = yx * cz + yy * sz;
        float y = yy * cz - yx * sz;
        float z = yw * sz - yz * cz;
        float w = yw * cz + yz * sz;
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Vector3f getEulerAnglesXYZ(Vector3f eulerAngles) {
        eulerAngles.x = (float)Math.atan2(2.0 * (double)(this.x * this.w - this.y * this.z), 1.0 - 2.0 * (double)(this.x * this.x + this.y * this.y));
        eulerAngles.y = (float)Math.asin(2.0 * (double)(this.x * this.z + this.y * this.w));
        eulerAngles.z = (float)Math.atan2(2.0 * (double)(this.z * this.w - this.x * this.y), 1.0 - 2.0 * (double)(this.y * this.y + this.z * this.z));
        return eulerAngles;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Quaternionf rotationXYZ(float angleX, float angleY, float angleZ) {
        float sx = (float)Math.sin((double)angleX * 0.5);
        float cx = (float)Math.cosFromSin(sx, (double)angleX * 0.5);
        float sy = (float)Math.sin((double)angleY * 0.5);
        float cy = (float)Math.cosFromSin(sy, (double)angleY * 0.5);
        float sz = (float)Math.sin((double)angleZ * 0.5);
        float cz = (float)Math.cosFromSin(sz, (double)angleZ * 0.5);
        float cycz = cy * cz;
        float sysz = sy * sz;
        float sycz = sy * cz;
        float cysz = cy * sz;
        this.w = cx * cycz - sx * sysz;
        this.x = sx * cycz + cx * sysz;
        this.y = cx * sycz - sx * cysz;
        this.z = cx * cysz + sx * sycz;
        return this;
    }

    public Quaternionf rotationZYX(float angleZ, float angleY, float angleX) {
        float sx = (float)Math.sin((double)angleX * 0.5);
        float cx = (float)Math.cosFromSin(sx, (double)angleX * 0.5);
        float sy = (float)Math.sin((double)angleY * 0.5);
        float cy = (float)Math.cosFromSin(sy, (double)angleY * 0.5);
        float sz = (float)Math.sin((double)angleZ * 0.5);
        float cz = (float)Math.cosFromSin(sz, (double)angleZ * 0.5);
        float cycz = cy * cz;
        float sysz = sy * sz;
        float sycz = sy * cz;
        float cysz = cy * sz;
        this.w = cx * cycz + sx * sysz;
        this.x = sx * cycz - cx * sysz;
        this.y = cx * sycz + sx * cysz;
        this.z = cx * cysz - sx * sycz;
        return this;
    }

    public Quaternionf rotationYXZ(float angleY, float angleX, float angleZ) {
        float sx = (float)Math.sin((double)angleX * 0.5);
        float cx = (float)Math.cosFromSin(sx, (double)angleX * 0.5);
        float sy = (float)Math.sin((double)angleY * 0.5);
        float cy = (float)Math.cosFromSin(sy, (double)angleY * 0.5);
        float sz = (float)Math.sin((double)angleZ * 0.5);
        float cz = (float)Math.cosFromSin(sz, (double)angleZ * 0.5);
        float x = cy * sx;
        float y = sy * cx;
        float z = sy * sx;
        float w = cy * cx;
        this.x = x * cz + y * sz;
        this.y = y * cz - x * sz;
        this.z = w * sz - z * cz;
        this.w = w * cz + z * sz;
        return this;
    }

    public Quaternionf slerp(Quaternionfc target, float alpha) {
        return this.slerp(target, alpha, this);
    }

    public Quaternionf slerp(Quaternionfc target, float alpha, Quaternionf dest) {
        float scale1;
        float scale0;
        float cosom = this.x * target.x() + this.y * target.y() + this.z * target.z() + this.w * target.w();
        float absCosom = Math.abs(cosom);
        if (1.0f - absCosom > 1.0E-6f) {
            float sinSqr = 1.0f - absCosom * absCosom;
            float sinom = (float)(1.0 / Math.sqrt(sinSqr));
            float omega = (float)Math.atan2(sinSqr * sinom, absCosom);
            scale0 = (float)(Math.sin((1.0 - (double)alpha) * (double)omega) * (double)sinom);
            scale1 = (float)(Math.sin(alpha * omega) * (double)sinom);
        } else {
            scale0 = 1.0f - alpha;
            scale1 = alpha;
        }
        scale1 = cosom >= 0.0f ? scale1 : -scale1;
        dest.x = scale0 * this.x + scale1 * target.x();
        dest.y = scale0 * this.y + scale1 * target.y();
        dest.z = scale0 * this.z + scale1 * target.z();
        dest.w = scale0 * this.w + scale1 * target.w();
        return dest;
    }

    public static Quaternionfc slerp(Quaternionf[] qs, float[] weights, Quaternionf dest) {
        dest.set(qs[0]);
        float w = weights[0];
        for (int i = 1; i < qs.length; ++i) {
            float w0 = w;
            float w1 = weights[i];
            float rw1 = w1 / (w0 + w1);
            w += w1;
            dest.slerp(qs[i], rw1);
        }
        return dest;
    }

    public Quaternionf scale(float factor) {
        return this.scale(factor, this);
    }

    public Quaternionf scale(float factor, Quaternionf dest) {
        float sqrt = (float)Math.sqrt(factor);
        dest.x = sqrt * this.x;
        dest.y = sqrt * this.y;
        dest.z = sqrt * this.z;
        dest.w = sqrt * this.w;
        return this;
    }

    public Quaternionf scaling(float factor) {
        float sqrt = (float)Math.sqrt(factor);
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = sqrt;
        return this;
    }

    public Quaternionf integrate(float dt, float vx, float vy, float vz) {
        return this.integrate(dt, vx, vy, vz, this);
    }

    public Quaternionf integrate(float dt, float vx, float vy, float vz, Quaternionf dest) {
        return this.rotateLocal(dt * vx, dt * vy, dt * vz, dest);
    }

    public Quaternionf nlerp(Quaternionfc q, float factor) {
        return this.nlerp(q, factor, this);
    }

    public Quaternionf nlerp(Quaternionfc q, float factor, Quaternionf dest) {
        float cosom = this.x * q.x() + this.y * q.y() + this.z * q.z() + this.w * q.w();
        float scale0 = 1.0f - factor;
        float scale1 = cosom >= 0.0f ? factor : -factor;
        dest.x = scale0 * this.x + scale1 * q.x();
        dest.y = scale0 * this.y + scale1 * q.y();
        dest.z = scale0 * this.z + scale1 * q.z();
        dest.w = scale0 * this.w + scale1 * q.w();
        float s = (float)(1.0 / Math.sqrt(dest.x * dest.x + dest.y * dest.y + dest.z * dest.z + dest.w * dest.w));
        dest.x *= s;
        dest.y *= s;
        dest.z *= s;
        dest.w *= s;
        return dest;
    }

    public static Quaternionfc nlerp(Quaternionfc[] qs, float[] weights, Quaternionf dest) {
        dest.set(qs[0]);
        float w = weights[0];
        for (int i = 1; i < qs.length; ++i) {
            float w0 = w;
            float w1 = weights[i];
            float rw1 = w1 / (w0 + w1);
            w += w1;
            dest.nlerp(qs[i], rw1);
        }
        return dest;
    }

    public Quaternionf nlerpIterative(Quaternionfc q, float alpha, float dotThreshold, Quaternionf dest) {
        float scale1;
        float scale0;
        float q2w;
        float q2z;
        float q2y;
        float q1x = this.x;
        float q1y = this.y;
        float q1z = this.z;
        float q1w = this.w;
        float q2x = q.x();
        float dot = q1x * q2x + q1y * (q2y = q.y()) + q1z * (q2z = q.z()) + q1w * (q2w = q.w());
        float absDot = Math.abs(dot);
        if (0.999999f < absDot) {
            return dest.set(this);
        }
        float alphaN = alpha;
        while (absDot < dotThreshold) {
            float s;
            scale0 = 0.5f;
            float f = scale1 = dot >= 0.0f ? 0.5f : -0.5f;
            if (alphaN < 0.5f) {
                q2x = scale0 * q2x + scale1 * q1x;
                q2y = scale0 * q2y + scale1 * q1y;
                q2z = scale0 * q2z + scale1 * q1z;
                q2w = scale0 * q2w + scale1 * q1w;
                s = (float)(1.0 / Math.sqrt(q2x * q2x + q2y * q2y + q2z * q2z + q2w * q2w));
                q2x *= s;
                q2y *= s;
                q2z *= s;
                q2w *= s;
                alphaN += alphaN;
            } else {
                q1x = scale0 * q1x + scale1 * q2x;
                q1y = scale0 * q1y + scale1 * q2y;
                q1z = scale0 * q1z + scale1 * q2z;
                q1w = scale0 * q1w + scale1 * q2w;
                s = (float)(1.0 / Math.sqrt(q1x * q1x + q1y * q1y + q1z * q1z + q1w * q1w));
                q1x *= s;
                q1y *= s;
                q1z *= s;
                q1w *= s;
                alphaN = alphaN + alphaN - 1.0f;
            }
            dot = q1x * q2x + q1y * q2y + q1z * q2z + q1w * q2w;
            absDot = Math.abs(dot);
        }
        scale0 = 1.0f - alphaN;
        scale1 = dot >= 0.0f ? alphaN : -alphaN;
        float resX = scale0 * q1x + scale1 * q2x;
        float resY = scale0 * q1y + scale1 * q2y;
        float resZ = scale0 * q1z + scale1 * q2z;
        float resW = scale0 * q1w + scale1 * q2w;
        float s = (float)(1.0 / Math.sqrt(resX * resX + resY * resY + resZ * resZ + resW * resW));
        dest.x = resX * s;
        dest.y = resY * s;
        dest.z = resZ * s;
        dest.w = resW * s;
        return dest;
    }

    public Quaternionf nlerpIterative(Quaternionfc q, float alpha, float dotThreshold) {
        return this.nlerpIterative(q, alpha, dotThreshold, this);
    }

    public static Quaternionfc nlerpIterative(Quaternionf[] qs, float[] weights, float dotThreshold, Quaternionf dest) {
        dest.set(qs[0]);
        float w = weights[0];
        for (int i = 1; i < qs.length; ++i) {
            float w0 = w;
            float w1 = weights[i];
            float rw1 = w1 / (w0 + w1);
            w += w1;
            dest.nlerpIterative(qs[i], rw1, dotThreshold);
        }
        return dest;
    }

    public Quaternionf lookAlong(Vector3fc dir, Vector3fc up) {
        return this.lookAlong(dir.x(), dir.y(), dir.z(), up.x(), up.y(), up.z(), this);
    }

    public Quaternionf lookAlong(Vector3fc dir, Vector3fc up, Quaternionf dest) {
        return this.lookAlong(dir.x(), dir.y(), dir.z(), up.x(), up.y(), up.z(), dest);
    }

    public Quaternionf lookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ) {
        return this.lookAlong(dirX, dirY, dirZ, upX, upY, upZ, this);
    }

    public Quaternionf lookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ, Quaternionf dest) {
        float z;
        float y;
        float x;
        float w;
        float invDirLength = (float)(1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ));
        float dirnX = dirX * invDirLength;
        float dirnY = dirY * invDirLength;
        float dirnZ = dirZ * invDirLength;
        float leftX = upY * dirnZ - upZ * dirnY;
        float leftY = upZ * dirnX - upX * dirnZ;
        float leftZ = upX * dirnY - upY * dirnX;
        float invLeftLength = (float)(1.0 / Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ));
        float upnX = dirnY * (leftZ *= invLeftLength) - dirnZ * (leftY *= invLeftLength);
        float upnY = dirnZ * (leftX *= invLeftLength) - dirnX * leftZ;
        float upnZ = dirnX * leftY - dirnY * leftX;
        double tr = leftX + upnY + dirnZ;
        if (tr >= 0.0) {
            double t = Math.sqrt(tr + 1.0);
            w = (float)(t * 0.5);
            t = 0.5 / t;
            x = (float)((double)(dirnY - upnZ) * t);
            y = (float)((double)(leftZ - dirnX) * t);
            z = (float)((double)(upnX - leftY) * t);
        } else if (leftX > upnY && leftX > dirnZ) {
            double t = Math.sqrt(1.0 + (double)leftX - (double)upnY - (double)dirnZ);
            x = (float)(t * 0.5);
            t = 0.5 / t;
            y = (float)((double)(leftY + upnX) * t);
            z = (float)((double)(dirnX + leftZ) * t);
            w = (float)((double)(dirnY - upnZ) * t);
        } else if (upnY > dirnZ) {
            double t = Math.sqrt(1.0 + (double)upnY - (double)leftX - (double)dirnZ);
            y = (float)(t * 0.5);
            t = 0.5 / t;
            x = (float)((double)(leftY + upnX) * t);
            z = (float)((double)(upnZ + dirnY) * t);
            w = (float)((double)(leftZ - dirnX) * t);
        } else {
            double t = Math.sqrt(1.0 + (double)dirnZ - (double)leftX - (double)upnY);
            z = (float)(t * 0.5);
            t = 0.5 / t;
            x = (float)((double)(dirnX + leftZ) * t);
            y = (float)((double)(upnZ + dirnY) * t);
            w = (float)((double)(upnX - leftY) * t);
        }
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaternionf rotationTo(float fromDirX, float fromDirY, float fromDirZ, float toDirX, float toDirY, float toDirZ) {
        this.x = fromDirY * toDirZ - fromDirZ * toDirY;
        this.y = fromDirZ * toDirX - fromDirX * toDirZ;
        this.z = fromDirX * toDirY - fromDirY * toDirX;
        this.w = (float)Math.sqrt((fromDirX * fromDirX + fromDirY * fromDirY + fromDirZ * fromDirZ) * (toDirX * toDirX + toDirY * toDirY + toDirZ * toDirZ)) + (fromDirX * toDirX + fromDirY * toDirY + fromDirZ * toDirZ);
        float invNorm = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w));
        if (Float.isInfinite(invNorm)) {
            this.x = toDirY;
            this.y = -toDirX;
            this.z = 0.0f;
            this.w = 0.0f;
            invNorm = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y));
            if (Float.isInfinite(invNorm)) {
                this.x = 0.0f;
                this.y = toDirZ;
                this.z = -toDirY;
                this.w = 0.0f;
                invNorm = (float)(1.0 / Math.sqrt(this.y * this.y + this.z * this.z));
            }
        }
        this.x *= invNorm;
        this.y *= invNorm;
        this.z *= invNorm;
        this.w *= invNorm;
        return this;
    }

    public Quaternionf rotationTo(Vector3fc fromDir, Vector3fc toDir) {
        return this.rotationTo(fromDir.x(), fromDir.y(), fromDir.z(), toDir.x(), toDir.y(), toDir.z());
    }

    public Quaternionf rotateTo(float fromDirX, float fromDirY, float fromDirZ, float toDirX, float toDirY, float toDirZ, Quaternionf dest) {
        float x = fromDirY * toDirZ - fromDirZ * toDirY;
        float y = fromDirZ * toDirX - fromDirX * toDirZ;
        float z = fromDirX * toDirY - fromDirY * toDirX;
        float w = (float)Math.sqrt((fromDirX * fromDirX + fromDirY * fromDirY + fromDirZ * fromDirZ) * (toDirX * toDirX + toDirY * toDirY + toDirZ * toDirZ)) + (fromDirX * toDirX + fromDirY * toDirY + fromDirZ * toDirZ);
        float invNorm = (float)(1.0 / Math.sqrt(x * x + y * y + z * z + w * w));
        if (Float.isInfinite(invNorm)) {
            x = toDirY;
            y = -toDirX;
            z = 0.0f;
            w = 0.0f;
            invNorm = (float)(1.0 / Math.sqrt(x * x + y * y));
            if (Float.isInfinite(invNorm)) {
                x = 0.0f;
                y = toDirZ;
                z = -toDirY;
                w = 0.0f;
                invNorm = (float)(1.0 / Math.sqrt(y * y + z * z));
            }
        }
        dest.set(this.w * (x *= invNorm) + this.x * (w *= invNorm) + this.y * (z *= invNorm) - this.z * (y *= invNorm), this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaternionf rotateTo(float fromDirX, float fromDirY, float fromDirZ, float toDirX, float toDirY, float toDirZ) {
        return this.rotateTo(fromDirX, fromDirY, fromDirZ, toDirX, toDirY, toDirZ, this);
    }

    public Quaternionf rotateTo(Vector3fc fromDir, Vector3fc toDir, Quaternionf dest) {
        return this.rotateTo(fromDir.x(), fromDir.y(), fromDir.z(), toDir.x(), toDir.y(), toDir.z(), dest);
    }

    public Quaternionf rotateTo(Vector3fc fromDir, Vector3fc toDir) {
        return this.rotateTo(fromDir.x(), fromDir.y(), fromDir.z(), toDir.x(), toDir.y(), toDir.z(), this);
    }

    public Quaternionf rotate(float angleX, float angleY, float angleZ) {
        return this.rotate(angleX, angleY, angleZ, this);
    }

    public Quaternionf rotate(float angleX, float angleY, float angleZ, Quaternionf dest) {
        double s;
        double dqW;
        double thetaX = (double)angleX * 0.5;
        double thetaY = (double)angleY * 0.5;
        double thetaZ = (double)angleZ * 0.5;
        double thetaMagSq = thetaX * thetaX + thetaY * thetaY + thetaZ * thetaZ;
        if (thetaMagSq * thetaMagSq / 24.0 < (double)1.0E-8f) {
            dqW = 1.0 - thetaMagSq / 2.0;
            s = 1.0 - thetaMagSq / 6.0;
        } else {
            double thetaMag = Math.sqrt(thetaMagSq);
            double sin = Math.sin(thetaMag);
            s = sin / thetaMag;
            dqW = Math.cosFromSin(sin, thetaMag);
        }
        double dqX = thetaX * s;
        double dqY = thetaY * s;
        double dqZ = thetaZ * s;
        dest.set((float)((double)this.w * dqX + (double)this.x * dqW + (double)this.y * dqZ - (double)this.z * dqY), (float)((double)this.w * dqY - (double)this.x * dqZ + (double)this.y * dqW + (double)this.z * dqX), (float)((double)this.w * dqZ + (double)this.x * dqY - (double)this.y * dqX + (double)this.z * dqW), (float)((double)this.w * dqW - (double)this.x * dqX - (double)this.y * dqY - (double)this.z * dqZ));
        return dest;
    }

    public Quaternionf rotateLocal(float angleX, float angleY, float angleZ) {
        return this.rotateLocal(angleX, angleY, angleZ, this);
    }

    public Quaternionf rotateLocal(float angleX, float angleY, float angleZ, Quaternionf dest) {
        float s;
        float dqW;
        float thetaX = angleX * 0.5f;
        float thetaY = angleY * 0.5f;
        float thetaZ = angleZ * 0.5f;
        float thetaMagSq = thetaX * thetaX + thetaY * thetaY + thetaZ * thetaZ;
        if (thetaMagSq * thetaMagSq / 24.0f < 1.0E-8f) {
            dqW = 1.0f - thetaMagSq * 0.5f;
            s = 1.0f - thetaMagSq / 6.0f;
        } else {
            float thetaMag = (float)Math.sqrt(thetaMagSq);
            float sin = (float)Math.sin(thetaMag);
            s = sin / thetaMag;
            dqW = (float)Math.cosFromSin(sin, thetaMag);
        }
        float dqX = thetaX * s;
        float dqY = thetaY * s;
        float dqZ = thetaZ * s;
        dest.set(dqW * this.x + dqX * this.w + dqY * this.z - dqZ * this.y, dqW * this.y - dqX * this.z + dqY * this.w + dqZ * this.x, dqW * this.z + dqX * this.y - dqY * this.x + dqZ * this.w, dqW * this.w - dqX * this.x - dqY * this.y - dqZ * this.z);
        return dest;
    }

    public Quaternionf rotateX(float angle) {
        return this.rotateX(angle, this);
    }

    public Quaternionf rotateX(float angle, Quaternionf dest) {
        float sin = (float)Math.sin((double)angle * 0.5);
        float cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        dest.set(this.w * sin + this.x * cos, this.y * cos + this.z * sin, this.z * cos - this.y * sin, this.w * cos - this.x * sin);
        return dest;
    }

    public Quaternionf rotateY(float angle) {
        return this.rotateY(angle, this);
    }

    public Quaternionf rotateY(float angle, Quaternionf dest) {
        float sin = (float)Math.sin((double)angle * 0.5);
        float cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        dest.set(this.x * cos - this.z * sin, this.w * sin + this.y * cos, this.x * sin + this.z * cos, this.w * cos - this.y * sin);
        return dest;
    }

    public Quaternionf rotateZ(float angle) {
        return this.rotateZ(angle, this);
    }

    public Quaternionf rotateZ(float angle, Quaternionf dest) {
        float sin = (float)Math.sin((double)angle * 0.5);
        float cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        dest.set(this.x * cos + this.y * sin, this.y * cos - this.x * sin, this.w * sin + this.z * cos, this.w * cos - this.z * sin);
        return dest;
    }

    public Quaternionf rotateLocalX(float angle) {
        return this.rotateLocalX(angle, this);
    }

    public Quaternionf rotateLocalX(float angle, Quaternionf dest) {
        float hangle = angle * 0.5f;
        float s = (float)Math.sin(hangle);
        float c = (float)Math.cosFromSin(s, hangle);
        dest.set(c * this.x + s * this.w, c * this.y - s * this.z, c * this.z + s * this.y, c * this.w - s * this.x);
        return dest;
    }

    public Quaternionf rotateLocalY(float angle) {
        return this.rotateLocalY(angle, this);
    }

    public Quaternionf rotateLocalY(float angle, Quaternionf dest) {
        float hangle = angle * 0.5f;
        float s = (float)Math.sin(hangle);
        float c = (float)Math.cosFromSin(s, hangle);
        dest.set(c * this.x + s * this.z, c * this.y + s * this.w, c * this.z - s * this.x, c * this.w - s * this.y);
        return dest;
    }

    public Quaternionf rotateLocalZ(float angle) {
        return this.rotateLocalZ(angle, this);
    }

    public Quaternionf rotateLocalZ(float angle, Quaternionf dest) {
        float hangle = angle * 0.5f;
        float s = (float)Math.sin(hangle);
        float c = (float)Math.cosFromSin(s, hangle);
        dest.set(c * this.x - s * this.y, c * this.y + s * this.x, c * this.z + s * this.w, c * this.w - s * this.z);
        return dest;
    }

    public Quaternionf rotateAxis(float angle, float axisX, float axisY, float axisZ, Quaternionf dest) {
        double hangle = (double)angle / 2.0;
        double sinAngle = Math.sin(hangle);
        double invVLength = 1.0 / Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        double rx = (double)axisX * invVLength * sinAngle;
        double ry = (double)axisY * invVLength * sinAngle;
        double rz = (double)axisZ * invVLength * sinAngle;
        double rw = Math.cosFromSin(sinAngle, hangle);
        dest.set((float)((double)this.w * rx + (double)this.x * rw + (double)this.y * rz - (double)this.z * ry), (float)((double)this.w * ry - (double)this.x * rz + (double)this.y * rw + (double)this.z * rx), (float)((double)this.w * rz + (double)this.x * ry - (double)this.y * rx + (double)this.z * rw), (float)((double)this.w * rw - (double)this.x * rx - (double)this.y * ry - (double)this.z * rz));
        return dest;
    }

    public Quaternionf rotateAxis(float angle, Vector3fc axis, Quaternionf dest) {
        return this.rotateAxis(angle, axis.x(), axis.y(), axis.z(), dest);
    }

    public Quaternionf rotateAxis(float angle, Vector3fc axis) {
        return this.rotateAxis(angle, axis.x(), axis.y(), axis.z(), this);
    }

    public Quaternionf rotateAxis(float angle, float axisX, float axisY, float axisZ) {
        return this.rotateAxis(angle, axisX, axisY, axisZ, this);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.w);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
        this.w = in.readFloat();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.w);
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quaternionf other = (Quaternionf)obj;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(other.w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public Quaternionf difference(Quaternionf other) {
        return this.difference(other, this);
    }

    public Quaternionf difference(Quaternionf other, Quaternionf dest) {
        float invNorm = 1.0f / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        float x = -this.x * invNorm;
        float y = -this.y * invNorm;
        float z = -this.z * invNorm;
        float w = this.w * invNorm;
        dest.set(w * other.x + x * other.w + y * other.z - z * other.y, w * other.y - x * other.z + y * other.w + z * other.x, w * other.z + x * other.y - y * other.x + z * other.w, w * other.w - x * other.x - y * other.y - z * other.z);
        return dest;
    }

    public Vector3f positiveX(Vector3f dir) {
        float invNorm = 1.0f / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        float nx = -this.x * invNorm;
        float ny = -this.y * invNorm;
        float nz = -this.z * invNorm;
        float nw = this.w * invNorm;
        float dy = ny + ny;
        float dz = nz + nz;
        dir.x = -ny * dy - nz * dz + 1.0f;
        dir.y = nx * dy + nw * dz;
        dir.z = nx * dz - nw * dy;
        return dir;
    }

    public Vector3f normalizedPositiveX(Vector3f dir) {
        float dy = this.y + this.y;
        float dz = this.z + this.z;
        dir.x = -this.y * dy - this.z * dz + 1.0f;
        dir.y = this.x * dy - this.w * dz;
        dir.z = this.x * dz + this.w * dy;
        return dir;
    }

    public Vector3f positiveY(Vector3f dir) {
        float invNorm = 1.0f / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        float nx = -this.x * invNorm;
        float ny = -this.y * invNorm;
        float nz = -this.z * invNorm;
        float nw = this.w * invNorm;
        float dx = nx + nx;
        float dy = ny + ny;
        float dz = nz + nz;
        dir.x = nx * dy - nw * dz;
        dir.y = -nx * dx - nz * dz + 1.0f;
        dir.z = ny * dz + nw * dx;
        return dir;
    }

    public Vector3f normalizedPositiveY(Vector3f dir) {
        float dx = this.x + this.x;
        float dy = this.y + this.y;
        float dz = this.z + this.z;
        dir.x = this.x * dy + this.w * dz;
        dir.y = -this.x * dx - this.z * dz + 1.0f;
        dir.z = this.y * dz - this.w * dx;
        return dir;
    }

    public Vector3f positiveZ(Vector3f dir) {
        float invNorm = 1.0f / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        float nx = -this.x * invNorm;
        float ny = -this.y * invNorm;
        float nz = -this.z * invNorm;
        float nw = this.w * invNorm;
        float dx = nx + nx;
        float dy = ny + ny;
        float dz = nz + nz;
        dir.x = nx * dz + nw * dy;
        dir.y = ny * dz - nw * dx;
        dir.z = -nx * dx - ny * dy + 1.0f;
        return dir;
    }

    public Vector3f normalizedPositiveZ(Vector3f dir) {
        float dx = this.x + this.x;
        float dy = this.y + this.y;
        float dz = this.z + this.z;
        dir.x = this.x * dz - this.w * dy;
        dir.y = this.y * dz + this.w * dx;
        dir.z = -this.x * dx - this.y * dy + 1.0f;
        return dir;
    }

    public Quaternionfc toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Quaternionfc {
        private final Quaternionfc delegate;

        Proxy(Quaternionfc delegate) {
            this.delegate = delegate;
        }

        public float x() {
            return this.delegate.x();
        }

        public float y() {
            return this.delegate.y();
        }

        public float z() {
            return this.delegate.z();
        }

        public float w() {
            return this.delegate.w();
        }

        public Quaternionf normalize(Quaternionf dest) {
            return this.delegate.normalize(dest);
        }

        public Quaternionf add(float x, float y, float z, float w, Quaternionf dest) {
            return this.delegate.add(x, y, z, w, dest);
        }

        public Quaternionf add(Quaternionfc q2, Quaternionf dest) {
            return this.delegate.add(q2, dest);
        }

        public float angle() {
            return this.delegate.angle();
        }

        public Matrix3f get(Matrix3f dest) {
            return this.delegate.get(dest);
        }

        public Matrix3d get(Matrix3d dest) {
            return this.delegate.get(dest);
        }

        public Matrix4f get(Matrix4f dest) {
            return this.delegate.get(dest);
        }

        public Matrix4d get(Matrix4d dest) {
            return this.delegate.get(dest);
        }

        public Matrix4x3f get(Matrix4x3f dest) {
            return this.delegate.get(dest);
        }

        public Matrix4x3d get(Matrix4x3d dest) {
            return this.delegate.get(dest);
        }

        public AxisAngle4f get(AxisAngle4f dest) {
            return this.delegate.get(dest);
        }

        public Quaterniond get(Quaterniond dest) {
            return this.delegate.get(dest);
        }

        public Quaternionf get(Quaternionf dest) {
            return this.delegate.get(dest);
        }

        public ByteBuffer getAsMatrix3f(ByteBuffer dest) {
            return this.delegate.getAsMatrix3f(dest);
        }

        public FloatBuffer getAsMatrix3f(FloatBuffer dest) {
            return this.delegate.getAsMatrix3f(dest);
        }

        public ByteBuffer getAsMatrix4f(ByteBuffer dest) {
            return this.delegate.getAsMatrix4f(dest);
        }

        public FloatBuffer getAsMatrix4f(FloatBuffer dest) {
            return this.delegate.getAsMatrix4f(dest);
        }

        public ByteBuffer getAsMatrix4x3f(ByteBuffer dest) {
            return this.delegate.getAsMatrix4x3f(dest);
        }

        public FloatBuffer getAsMatrix4x3f(FloatBuffer dest) {
            return this.delegate.getAsMatrix4x3f(dest);
        }

        public Quaternionf mul(Quaternionfc q, Quaternionf dest) {
            return this.delegate.mul(q, dest);
        }

        public Quaternionf mul(float qx, float qy, float qz, float qw, Quaternionf dest) {
            return this.delegate.mul(qx, qy, qz, qw, dest);
        }

        public Quaternionf premul(Quaternionfc q, Quaternionf dest) {
            return this.delegate.premul(q, dest);
        }

        public Quaternionf premul(float qx, float qy, float qz, float qw, Quaternionf dest) {
            return this.delegate.premul(qx, qy, qz, qw, dest);
        }

        public Vector3f transform(Vector3f vec) {
            return this.delegate.transform(vec);
        }

        public Vector4f transform(Vector4f vec) {
            return this.delegate.transform(vec);
        }

        public Vector3f transform(Vector3fc vec, Vector3f dest) {
            return this.delegate.transform(vec, dest);
        }

        public Vector3f transform(float x, float y, float z, Vector3f dest) {
            return this.delegate.transform(x, y, z, dest);
        }

        public Vector4f transform(Vector4fc vec, Vector4f dest) {
            return this.delegate.transform(vec, dest);
        }

        public Vector4f transform(float x, float y, float z, Vector4f dest) {
            return this.delegate.transform(x, y, z, dest);
        }

        public Quaternionf invert(Quaternionf dest) {
            return this.delegate.invert(dest);
        }

        public Quaternionf div(Quaternionfc b, Quaternionf dest) {
            return this.delegate.div(b, dest);
        }

        public Quaternionf conjugate(Quaternionf dest) {
            return this.delegate.conjugate(dest);
        }

        public Quaternionf rotateXYZ(float angleX, float angleY, float angleZ, Quaternionf dest) {
            return this.delegate.rotateXYZ(angleX, angleY, angleZ, dest);
        }

        public Quaternionf rotateZYX(float angleZ, float angleY, float angleX, Quaternionf dest) {
            return this.delegate.rotateZYX(angleZ, angleY, angleX, dest);
        }

        public Quaternionf rotateYXZ(float angleY, float angleX, float angleZ, Quaternionf dest) {
            return this.delegate.rotateYXZ(angleY, angleX, angleZ, dest);
        }

        public Vector3f getEulerAnglesXYZ(Vector3f eulerAngles) {
            return this.delegate.getEulerAnglesXYZ(eulerAngles);
        }

        public float lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public Quaternionf slerp(Quaternionfc target, float alpha, Quaternionf dest) {
            return this.delegate.slerp(target, alpha, dest);
        }

        public Quaternionf scale(float factor, Quaternionf dest) {
            return this.delegate.scale(factor, dest);
        }

        public Quaternionf integrate(float dt, float vx, float vy, float vz, Quaternionf dest) {
            return this.delegate.integrate(dt, vx, vy, vz, dest);
        }

        public Quaternionf nlerp(Quaternionfc q, float factor, Quaternionf dest) {
            return this.delegate.nlerp(q, factor, dest);
        }

        public Quaternionf nlerpIterative(Quaternionfc q, float alpha, float dotThreshold, Quaternionf dest) {
            return this.delegate.nlerpIterative(q, alpha, dotThreshold, dest);
        }

        public Quaternionf lookAlong(Vector3fc dir, Vector3fc up, Quaternionf dest) {
            return this.delegate.lookAlong(dir, up, dest);
        }

        public Quaternionf lookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ, Quaternionf dest) {
            return this.delegate.lookAlong(dirX, dirY, dirZ, upX, upY, upZ, dest);
        }

        public Quaternionf rotateTo(float fromDirX, float fromDirY, float fromDirZ, float toDirX, float toDirY, float toDirZ, Quaternionf dest) {
            return this.delegate.rotateTo(fromDirX, fromDirY, fromDirZ, toDirX, toDirY, toDirZ, dest);
        }

        public Quaternionf rotateTo(Vector3fc fromDir, Vector3fc toDir, Quaternionf dest) {
            return this.delegate.rotateTo(fromDir, toDir, dest);
        }

        public Quaternionf rotate(float angleX, float angleY, float angleZ, Quaternionf dest) {
            return this.delegate.rotate(angleX, angleY, angleZ, dest);
        }

        public Quaternionf rotateLocal(float angleX, float angleY, float angleZ, Quaternionf dest) {
            return this.delegate.rotateLocal(angleX, angleY, angleZ, dest);
        }

        public Quaternionf rotateX(float angle, Quaternionf dest) {
            return this.delegate.rotateX(angle, dest);
        }

        public Quaternionf rotateY(float angle, Quaternionf dest) {
            return this.delegate.rotateY(angle, dest);
        }

        public Quaternionf rotateZ(float angle, Quaternionf dest) {
            return this.delegate.rotateZ(angle, dest);
        }

        public Quaternionf rotateLocalX(float angle, Quaternionf dest) {
            return this.delegate.rotateLocalX(angle, dest);
        }

        public Quaternionf rotateLocalY(float angle, Quaternionf dest) {
            return this.delegate.rotateLocalY(angle, dest);
        }

        public Quaternionf rotateLocalZ(float angle, Quaternionf dest) {
            return this.delegate.rotateLocalZ(angle, dest);
        }

        public Quaternionf rotateAxis(float angle, float axisX, float axisY, float axisZ, Quaternionf dest) {
            return this.delegate.rotateAxis(angle, axisX, axisY, axisZ, dest);
        }

        public Quaternionf rotateAxis(float angle, Vector3fc axis, Quaternionf dest) {
            return this.delegate.rotateAxis(angle, axis, dest);
        }

        public Quaternionf difference(Quaternionf other, Quaternionf dest) {
            return this.delegate.difference(other, dest);
        }

        public Vector3f positiveX(Vector3f dir) {
            return this.delegate.positiveX(dir);
        }

        public Vector3f normalizedPositiveX(Vector3f dir) {
            return this.delegate.normalizedPositiveX(dir);
        }

        public Vector3f positiveY(Vector3f dir) {
            return this.delegate.positiveY(dir);
        }

        public Vector3f normalizedPositiveY(Vector3f dir) {
            return this.delegate.normalizedPositiveY(dir);
        }

        public Vector3f positiveZ(Vector3f dir) {
            return this.delegate.positiveZ(dir);
        }

        public Vector3f normalizedPositiveZ(Vector3f dir) {
            return this.delegate.normalizedPositiveZ(dir);
        }
    }
}

