/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;
import org.joml.Vector4dc;

public class Quaterniond
implements Externalizable,
Quaterniondc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Quaterniond() {
        this.w = 1.0;
    }

    public Quaterniond(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaterniond(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = 1.0;
    }

    public Quaterniond(Quaterniondc source) {
        this.x = source.x();
        this.y = source.y();
        this.z = source.z();
        this.w = source.w();
    }

    public Quaterniond(Quaternionfc source) {
        this.x = source.x();
        this.y = source.y();
        this.z = source.z();
        this.w = source.w();
    }

    public Quaterniond(AxisAngle4f axisAngle) {
        double s = Math.sin((double)axisAngle.angle * 0.5);
        this.x = (double)axisAngle.x * s;
        this.y = (double)axisAngle.y * s;
        this.z = (double)axisAngle.z * s;
        this.w = Math.cosFromSin(s, (double)axisAngle.angle * 0.5);
    }

    public Quaterniond(AxisAngle4d axisAngle) {
        double s = Math.sin(axisAngle.angle * 0.5);
        this.x = axisAngle.x * s;
        this.y = axisAngle.y * s;
        this.z = axisAngle.z * s;
        this.w = Math.cosFromSin(s, axisAngle.angle * 0.5);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double w() {
        return this.w;
    }

    public Quaterniond normalize() {
        double invNorm = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        this.x *= invNorm;
        this.y *= invNorm;
        this.z *= invNorm;
        this.w *= invNorm;
        return this;
    }

    public Quaterniond normalize(Quaterniond dest) {
        double invNorm = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        dest.x = this.x * invNorm;
        dest.y = this.y * invNorm;
        dest.z = this.z * invNorm;
        dest.w = this.w * invNorm;
        return dest;
    }

    public Quaterniond add(double x, double y, double z, double w) {
        return this.add(x, y, z, w, this);
    }

    public Quaterniond add(double x, double y, double z, double w, Quaterniond dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        dest.w = this.w + w;
        return dest;
    }

    public Quaterniond add(Quaterniondc q2) {
        this.x += q2.x();
        this.y += q2.y();
        this.z += q2.z();
        this.w += q2.w();
        return this;
    }

    public Quaterniond add(Quaterniondc q2, Quaterniond dest) {
        dest.x = this.x + q2.x();
        dest.y = this.y + q2.y();
        dest.z = this.z + q2.z();
        dest.w = this.w + q2.w();
        return dest;
    }

    public double dot(Quaterniondc otherQuat) {
        return this.x * otherQuat.x() + this.y * otherQuat.y() + this.z * otherQuat.z() + this.w * otherQuat.w();
    }

    public double angle() {
        double angle = 2.0 * Math.acos(this.w);
        return angle <= java.lang.Math.PI ? angle : java.lang.Math.PI * 2 - angle;
    }

    public Matrix3d get(Matrix3d dest) {
        return dest.set(this);
    }

    public Matrix3f get(Matrix3f dest) {
        return dest.set(this);
    }

    public Matrix4d get(Matrix4d dest) {
        return dest.set(this);
    }

    public Matrix4f get(Matrix4f dest) {
        return dest.set(this);
    }

    public Quaterniond get(Quaterniond dest) {
        return dest.set(this);
    }

    public Quaterniond set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaterniond set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Quaterniond set(Quaterniondc q) {
        this.x = q.x();
        this.y = q.y();
        this.z = q.z();
        this.w = q.w();
        return this;
    }

    public Quaterniond set(Quaternionfc q) {
        this.x = q.x();
        this.y = q.y();
        this.z = q.z();
        this.w = q.w();
        return this;
    }

    public Quaterniond set(AxisAngle4f axisAngle) {
        return this.setAngleAxis(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Quaterniond set(AxisAngle4d axisAngle) {
        return this.setAngleAxis(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Quaterniond setAngleAxis(double angle, double x, double y, double z) {
        double s = Math.sin(angle * 0.5);
        this.x = x * s;
        this.y = y * s;
        this.z = z * s;
        this.w = Math.cosFromSin(s, angle * 0.5);
        return this;
    }

    public Quaterniond setAngleAxis(double angle, Vector3dc axis) {
        return this.setAngleAxis(angle, axis.x(), axis.y(), axis.z());
    }

    private void setFromUnnormalized(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double nm00 = m00;
        double nm01 = m01;
        double nm02 = m02;
        double nm10 = m10;
        double nm11 = m11;
        double nm12 = m12;
        double nm20 = m20;
        double nm21 = m21;
        double nm22 = m22;
        double lenX = 1.0 / Math.sqrt(m00 * m00 + m01 * m01 + m02 * m02);
        double lenY = 1.0 / Math.sqrt(m10 * m10 + m11 * m11 + m12 * m12);
        double lenZ = 1.0 / Math.sqrt(m20 * m20 + m21 * m21 + m22 * m22);
        this.setFromNormalized(nm00 *= lenX, nm01 *= lenX, nm02 *= lenX, nm10 *= lenY, nm11 *= lenY, nm12 *= lenY, nm20 *= lenZ, nm21 *= lenZ, nm22 *= lenZ);
    }

    private void setFromNormalized(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double tr = m00 + m11 + m22;
        if (tr >= 0.0) {
            double t = Math.sqrt(tr + 1.0);
            this.w = t * 0.5;
            t = 0.5 / t;
            this.x = (m12 - m21) * t;
            this.y = (m20 - m02) * t;
            this.z = (m01 - m10) * t;
        } else if (m00 >= m11 && m00 >= m22) {
            double t = Math.sqrt(m00 - (m11 + m22) + 1.0);
            this.x = t * 0.5;
            t = 0.5 / t;
            this.y = (m10 + m01) * t;
            this.z = (m02 + m20) * t;
            this.w = (m12 - m21) * t;
        } else if (m11 > m22) {
            double t = Math.sqrt(m11 - (m22 + m00) + 1.0);
            this.y = t * 0.5;
            t = 0.5 / t;
            this.z = (m21 + m12) * t;
            this.x = (m10 + m01) * t;
            this.w = (m20 - m02) * t;
        } else {
            double t = Math.sqrt(m22 - (m00 + m11) + 1.0);
            this.z = t * 0.5;
            t = 0.5 / t;
            this.x = (m02 + m20) * t;
            this.y = (m21 + m12) * t;
            this.w = (m01 - m10) * t;
        }
    }

    public Quaterniond setFromUnnormalized(Matrix4fc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4x3fc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4x3dc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4fc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4x3fc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4x3dc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4dc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4dc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix3fc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix3fc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix3dc mat) {
        this.setFromUnnormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix3dc mat) {
        this.setFromNormalized(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
        return this;
    }

    public Quaterniond fromAxisAngleRad(Vector3dc axis, double angle) {
        return this.fromAxisAngleRad(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaterniond fromAxisAngleRad(double axisX, double axisY, double axisZ, double angle) {
        double hangle = angle / 2.0;
        double sinAngle = Math.sin(hangle);
        double vLength = Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        this.x = axisX / vLength * sinAngle;
        this.y = axisY / vLength * sinAngle;
        this.z = axisZ / vLength * sinAngle;
        this.w = Math.cosFromSin(sinAngle, hangle);
        return this;
    }

    public Quaterniond fromAxisAngleDeg(Vector3dc axis, double angle) {
        return this.fromAxisAngleRad(axis.x(), axis.y(), axis.z(), Math.toRadians(angle));
    }

    public Quaterniond fromAxisAngleDeg(double axisX, double axisY, double axisZ, double angle) {
        return this.fromAxisAngleRad(axisX, axisY, axisZ, Math.toRadians(angle));
    }

    public Quaterniond mul(Quaterniondc q) {
        return this.mul(q, this);
    }

    public Quaterniond mul(Quaterniondc q, Quaterniond dest) {
        dest.set(this.w * q.x() + this.x * q.w() + this.y * q.z() - this.z * q.y(), this.w * q.y() - this.x * q.z() + this.y * q.w() + this.z * q.x(), this.w * q.z() + this.x * q.y() - this.y * q.x() + this.z * q.w(), this.w * q.w() - this.x * q.x() - this.y * q.y() - this.z * q.z());
        return dest;
    }

    public Quaterniond mul(double qx, double qy, double qz, double qw) {
        this.set(this.w * qx + this.x * qw + this.y * qz - this.z * qy, this.w * qy - this.x * qz + this.y * qw + this.z * qx, this.w * qz + this.x * qy - this.y * qx + this.z * qw, this.w * qw - this.x * qx - this.y * qy - this.z * qz);
        return this;
    }

    public Quaterniond mul(double qx, double qy, double qz, double qw, Quaterniond dest) {
        dest.set(this.w * qx + this.x * qw + this.y * qz - this.z * qy, this.w * qy - this.x * qz + this.y * qw + this.z * qx, this.w * qz + this.x * qy - this.y * qx + this.z * qw, this.w * qw - this.x * qx - this.y * qy - this.z * qz);
        return dest;
    }

    public Quaterniond premul(Quaterniondc q) {
        return this.premul(q, this);
    }

    public Quaterniond premul(Quaterniondc q, Quaterniond dest) {
        dest.set(q.w() * this.x + q.x() * this.w + q.y() * this.z - q.z() * this.y, q.w() * this.y - q.x() * this.z + q.y() * this.w + q.z() * this.x, q.w() * this.z + q.x() * this.y - q.y() * this.x + q.z() * this.w, q.w() * this.w - q.x() * this.x - q.y() * this.y - q.z() * this.z);
        return dest;
    }

    public Quaterniond premul(double qx, double qy, double qz, double qw) {
        return this.premul(qx, qy, qz, qw, this);
    }

    public Quaterniond premul(double qx, double qy, double qz, double qw, Quaterniond dest) {
        dest.set(qw * this.x + qx * this.w + qy * this.z - qz * this.y, qw * this.y - qx * this.z + qy * this.w + qz * this.x, qw * this.z + qx * this.y - qy * this.x + qz * this.w, qw * this.w - qx * this.x - qy * this.y - qz * this.z);
        return dest;
    }

    public Vector3d transform(Vector3d vec) {
        return this.transform(vec.x, vec.y, vec.z, vec);
    }

    public Vector4d transform(Vector4d vec) {
        return this.transform(vec, vec);
    }

    public Vector3d transform(Vector3dc vec, Vector3d dest) {
        return this.transform(vec.x(), vec.y(), vec.z(), dest);
    }

    public Vector3d transform(double x, double y, double z, Vector3d dest) {
        double w2 = this.w * this.w;
        double x2 = this.x * this.x;
        double y2 = this.y * this.y;
        double z2 = this.z * this.z;
        double zw = this.z * this.w;
        double xy = this.x * this.y;
        double xz = this.x * this.z;
        double yw = this.y * this.w;
        double yz = this.y * this.z;
        double xw = this.x * this.w;
        double m00 = w2 + x2 - z2 - y2;
        double m01 = xy + zw + zw + xy;
        double m02 = xz - yw + xz - yw;
        double m10 = -zw + xy - zw + xy;
        double m11 = y2 - z2 + w2 - x2;
        double m12 = yz + yz + xw + xw;
        double m20 = yw + xz + xz + yw;
        double m21 = yz + yz - xw - xw;
        double m22 = z2 - y2 - x2 + w2;
        dest.x = m00 * x + m10 * y + m20 * z;
        dest.y = m01 * x + m11 * y + m21 * z;
        dest.z = m02 * x + m12 * y + m22 * z;
        return dest;
    }

    public Vector4d transform(Vector4dc vec, Vector4d dest) {
        return this.transform(vec.x(), vec.y(), vec.z(), dest);
    }

    public Vector4d transform(double x, double y, double z, Vector4d dest) {
        double w2 = this.w * this.w;
        double x2 = this.x * this.x;
        double y2 = this.y * this.y;
        double z2 = this.z * this.z;
        double zw = this.z * this.w;
        double xy = this.x * this.y;
        double xz = this.x * this.z;
        double yw = this.y * this.w;
        double yz = this.y * this.z;
        double xw = this.x * this.w;
        double m00 = w2 + x2 - z2 - y2;
        double m01 = xy + zw + zw + xy;
        double m02 = xz - yw + xz - yw;
        double m10 = -zw + xy - zw + xy;
        double m11 = y2 - z2 + w2 - x2;
        double m12 = yz + yz + xw + xw;
        double m20 = yw + xz + xz + yw;
        double m21 = yz + yz - xw - xw;
        double m22 = z2 - y2 - x2 + w2;
        dest.x = m00 * x + m10 * y + m20 * z;
        dest.y = m01 * x + m11 * y + m21 * z;
        dest.z = m02 * x + m12 * y + m22 * z;
        return dest;
    }

    public Quaterniond invert(Quaterniond dest) {
        double invNorm = 1.0 / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        dest.x = -this.x * invNorm;
        dest.y = -this.y * invNorm;
        dest.z = -this.z * invNorm;
        dest.w = this.w * invNorm;
        return dest;
    }

    public Quaterniond invert() {
        return this.invert(this);
    }

    public Quaterniond div(Quaterniondc b, Quaterniond dest) {
        double invNorm = 1.0 / (b.x() * b.x() + b.y() * b.y() + b.z() * b.z() + b.w() * b.w());
        double x = -b.x() * invNorm;
        double y = -b.y() * invNorm;
        double z = -b.z() * invNorm;
        double w = b.w() * invNorm;
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaterniond div(Quaterniondc b) {
        return this.div(b, this);
    }

    public Quaterniond conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Quaterniond conjugate(Quaterniond dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = this.w;
        return dest;
    }

    public Quaterniond identity() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 1.0;
        return this;
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Quaterniond rotationXYZ(double angleX, double angleY, double angleZ) {
        double sx = Math.sin(angleX * 0.5);
        double cx = Math.cosFromSin(sx, angleX * 0.5);
        double sy = Math.sin(angleY * 0.5);
        double cy = Math.cosFromSin(sy, angleY * 0.5);
        double sz = Math.sin(angleZ * 0.5);
        double cz = Math.cosFromSin(sz, angleZ * 0.5);
        double cycz = cy * cz;
        double sysz = sy * sz;
        double sycz = sy * cz;
        double cysz = cy * sz;
        this.w = cx * cycz - sx * sysz;
        this.x = sx * cycz + cx * sysz;
        this.y = cx * sycz - sx * cysz;
        this.z = cx * cysz + sx * sycz;
        return this;
    }

    public Quaterniond rotationZYX(double angleZ, double angleY, double angleX) {
        double sx = Math.sin(angleX * 0.5);
        double cx = Math.cosFromSin(sx, angleX * 0.5);
        double sy = Math.sin(angleY * 0.5);
        double cy = Math.cosFromSin(sy, angleY * 0.5);
        double sz = Math.sin(angleZ * 0.5);
        double cz = Math.cosFromSin(sz, angleZ * 0.5);
        double cycz = cy * cz;
        double sysz = sy * sz;
        double sycz = sy * cz;
        double cysz = cy * sz;
        this.w = cx * cycz + sx * sysz;
        this.x = sx * cycz - cx * sysz;
        this.y = cx * sycz + sx * cysz;
        this.z = cx * cysz - sx * sycz;
        return this;
    }

    public Quaterniond rotationYXZ(double angleY, double angleX, double angleZ) {
        double sx = Math.sin(angleX * 0.5);
        double cx = Math.cosFromSin(sx, angleX * 0.5);
        double sy = Math.sin(angleY * 0.5);
        double cy = Math.cosFromSin(sy, angleY * 0.5);
        double sz = Math.sin(angleZ * 0.5);
        double cz = Math.cosFromSin(sz, angleZ * 0.5);
        double x = cy * sx;
        double y = sy * cx;
        double z = sy * sx;
        double w = cy * cx;
        this.x = x * cz + y * sz;
        this.y = y * cz - x * sz;
        this.z = w * sz - z * cz;
        this.w = w * cz + z * sz;
        return this;
    }

    public Quaterniond slerp(Quaterniondc target, double alpha) {
        return this.slerp(target, alpha, this);
    }

    public Quaterniond slerp(Quaterniondc target, double alpha, Quaterniond dest) {
        double scale1;
        double scale0;
        double cosom = this.x * target.x() + this.y * target.y() + this.z * target.z() + this.w * target.w();
        double absCosom = Math.abs(cosom);
        if (1.0 - absCosom > 1.0E-6) {
            double sinSqr = 1.0 - absCosom * absCosom;
            double sinom = 1.0 / Math.sqrt(sinSqr);
            double omega = Math.atan2(sinSqr * sinom, absCosom);
            scale0 = Math.sin((1.0 - alpha) * omega) * sinom;
            scale1 = Math.sin(alpha * omega) * sinom;
        } else {
            scale0 = 1.0 - alpha;
            scale1 = alpha;
        }
        scale1 = cosom >= 0.0 ? scale1 : -scale1;
        dest.x = scale0 * this.x + scale1 * target.x();
        dest.y = scale0 * this.y + scale1 * target.y();
        dest.z = scale0 * this.z + scale1 * target.z();
        dest.w = scale0 * this.w + scale1 * target.w();
        return dest;
    }

    public static Quaterniondc slerp(Quaterniond[] qs, double[] weights, Quaterniond dest) {
        dest.set(qs[0]);
        double w = weights[0];
        for (int i = 1; i < qs.length; ++i) {
            double w0 = w;
            double w1 = weights[i];
            double rw1 = w1 / (w0 + w1);
            w += w1;
            dest.slerp(qs[i], rw1);
        }
        return dest;
    }

    public Quaterniond scale(double factor) {
        return this.scale(factor, this);
    }

    public Quaterniond scale(double factor, Quaterniond dest) {
        double sqrt = Math.sqrt(factor);
        dest.x = sqrt * this.x;
        dest.y = sqrt * this.y;
        dest.z = sqrt * this.z;
        dest.w = sqrt * this.w;
        return this;
    }

    public Quaterniond scaling(float factor) {
        double sqrt = Math.sqrt(factor);
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = sqrt;
        return this;
    }

    public Quaterniond integrate(double dt, double vx, double vy, double vz) {
        return this.integrate(dt, vx, vy, vz, this);
    }

    public Quaterniond integrate(double dt, double vx, double vy, double vz, Quaterniond dest) {
        return this.rotateLocal(dt * vx, dt * vy, dt * vz, dest);
    }

    public Quaterniond nlerp(Quaterniondc q, double factor) {
        return this.nlerp(q, factor, this);
    }

    public Quaterniond nlerp(Quaterniondc q, double factor, Quaterniond dest) {
        double cosom = this.x * q.x() + this.y * q.y() + this.z * q.z() + this.w * q.w();
        double scale0 = 1.0 - factor;
        double scale1 = cosom >= 0.0 ? factor : -factor;
        dest.x = scale0 * this.x + scale1 * q.x();
        dest.y = scale0 * this.y + scale1 * q.y();
        dest.z = scale0 * this.z + scale1 * q.z();
        dest.w = scale0 * this.w + scale1 * q.w();
        double s = 1.0 / Math.sqrt(dest.x * dest.x + dest.y * dest.y + dest.z * dest.z + dest.w * dest.w);
        dest.x *= s;
        dest.y *= s;
        dest.z *= s;
        dest.w *= s;
        return dest;
    }

    public static Quaterniondc nlerp(Quaterniond[] qs, double[] weights, Quaterniond dest) {
        dest.set(qs[0]);
        double w = weights[0];
        for (int i = 1; i < qs.length; ++i) {
            double w0 = w;
            double w1 = weights[i];
            double rw1 = w1 / (w0 + w1);
            w += w1;
            dest.nlerp(qs[i], rw1);
        }
        return dest;
    }

    public Quaterniond nlerpIterative(Quaterniondc q, double alpha, double dotThreshold, Quaterniond dest) {
        double scale1;
        double scale0;
        double q2w;
        double q2z;
        double q2y;
        double q1x = this.x;
        double q1y = this.y;
        double q1z = this.z;
        double q1w = this.w;
        double q2x = q.x();
        double dot = q1x * q2x + q1y * (q2y = q.y()) + q1z * (q2z = q.z()) + q1w * (q2w = q.w());
        double absDot = Math.abs(dot);
        if (0.999999 < absDot) {
            return dest.set(this);
        }
        double alphaN = alpha;
        while (absDot < dotThreshold) {
            double s;
            scale0 = 0.5;
            double d = scale1 = dot >= 0.0 ? 0.5 : -0.5;
            if (alphaN < 0.5) {
                q2x = scale0 * q2x + scale1 * q1x;
                q2y = scale0 * q2y + scale1 * q1y;
                q2z = scale0 * q2z + scale1 * q1z;
                q2w = scale0 * q2w + scale1 * q1w;
                s = 1.0 / Math.sqrt(q2x * q2x + q2y * q2y + q2z * q2z + q2w * q2w);
                q2x *= s;
                q2y *= s;
                q2z *= s;
                q2w *= s;
                alphaN += alphaN;
            } else {
                q1x = scale0 * q1x + scale1 * q2x;
                q1y = scale0 * q1y + scale1 * q2y;
                q1z = scale0 * q1z + scale1 * q2z;
                q1w = scale0 * q1w + scale1 * q2w;
                s = 1.0 / Math.sqrt(q1x * q1x + q1y * q1y + q1z * q1z + q1w * q1w);
                q1x *= s;
                q1y *= s;
                q1z *= s;
                q1w *= s;
                alphaN = alphaN + alphaN - 1.0;
            }
            dot = q1x * q2x + q1y * q2y + q1z * q2z + q1w * q2w;
            absDot = Math.abs(dot);
        }
        scale0 = 1.0 - alphaN;
        scale1 = dot >= 0.0 ? alphaN : -alphaN;
        double destX = scale0 * q1x + scale1 * q2x;
        double destY = scale0 * q1y + scale1 * q2y;
        double destZ = scale0 * q1z + scale1 * q2z;
        double destW = scale0 * q1w + scale1 * q2w;
        double s = 1.0 / Math.sqrt(destX * destX + destY * destY + destZ * destZ + destW * destW);
        dest.x *= s;
        dest.y *= s;
        dest.z *= s;
        dest.w *= s;
        return dest;
    }

    public Quaterniond nlerpIterative(Quaterniondc q, double alpha, double dotThreshold) {
        return this.nlerpIterative(q, alpha, dotThreshold, this);
    }

    public static Quaterniond nlerpIterative(Quaterniondc[] qs, double[] weights, double dotThreshold, Quaterniond dest) {
        dest.set(qs[0]);
        double w = weights[0];
        for (int i = 1; i < qs.length; ++i) {
            double w0 = w;
            double w1 = weights[i];
            double rw1 = w1 / (w0 + w1);
            w += w1;
            dest.nlerpIterative(qs[i], rw1, dotThreshold);
        }
        return dest;
    }

    public Quaterniond lookAlong(Vector3dc dir, Vector3dc up) {
        return this.lookAlong(dir.x(), dir.y(), dir.z(), up.x(), up.y(), up.z(), this);
    }

    public Quaterniond lookAlong(Vector3dc dir, Vector3dc up, Quaterniond dest) {
        return this.lookAlong(dir.x(), dir.y(), dir.z(), up.x(), up.y(), up.z(), dest);
    }

    public Quaterniond lookAlong(double dirX, double dirY, double dirZ, double upX, double upY, double upZ) {
        return this.lookAlong(dirX, dirY, dirZ, upX, upY, upZ, this);
    }

    public Quaterniond lookAlong(double dirX, double dirY, double dirZ, double upX, double upY, double upZ, Quaterniond dest) {
        double z;
        double y;
        double x;
        double w;
        double invDirLength = 1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        double dirnX = dirX * invDirLength;
        double dirnY = dirY * invDirLength;
        double dirnZ = dirZ * invDirLength;
        double leftX = upY * dirnZ - upZ * dirnY;
        double leftY = upZ * dirnX - upX * dirnZ;
        double leftZ = upX * dirnY - upY * dirnX;
        double invLeftLength = 1.0 / Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        double upnX = dirnY * (leftZ *= invLeftLength) - dirnZ * (leftY *= invLeftLength);
        double upnY = dirnZ * (leftX *= invLeftLength) - dirnX * leftZ;
        double upnZ = dirnX * leftY - dirnY * leftX;
        double tr = leftX + upnY + dirnZ;
        if (tr >= 0.0) {
            double t = Math.sqrt(tr + 1.0);
            w = t * 0.5;
            t = 0.5 / t;
            x = (dirnY - upnZ) * t;
            y = (leftZ - dirnX) * t;
            z = (upnX - leftY) * t;
        } else if (leftX > upnY && leftX > dirnZ) {
            double t = Math.sqrt(1.0 + leftX - upnY - dirnZ);
            x = t * 0.5;
            t = 0.5 / t;
            y = (leftY + upnX) * t;
            z = (dirnX + leftZ) * t;
            w = (dirnY - upnZ) * t;
        } else if (upnY > dirnZ) {
            double t = Math.sqrt(1.0 + upnY - leftX - dirnZ);
            y = t * 0.5;
            t = 0.5 / t;
            x = (leftY + upnX) * t;
            z = (upnZ + dirnY) * t;
            w = (leftZ - dirnX) * t;
        } else {
            double t = Math.sqrt(1.0 + dirnZ - leftX - upnY);
            z = t * 0.5;
            t = 0.5 / t;
            x = (dirnX + leftZ) * t;
            y = (upnZ + dirnY) * t;
            w = (upnX - leftY) * t;
        }
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeDouble(this.w);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.w = in.readDouble();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.w);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quaterniond other = (Quaterniond)obj;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(other.w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public Quaterniond difference(Quaterniondc other) {
        return this.difference(other, this);
    }

    public Quaterniond difference(Quaterniondc other, Quaterniond dest) {
        double invNorm = 1.0 / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        double x = -this.x * invNorm;
        double y = -this.y * invNorm;
        double z = -this.z * invNorm;
        double w = this.w * invNorm;
        dest.set(w * other.x() + x * other.w() + y * other.z() - z * other.y(), w * other.y() - x * other.z() + y * other.w() + z * other.x(), w * other.z() + x * other.y() - y * other.x() + z * other.w(), w * other.w() - x * other.x() - y * other.y() - z * other.z());
        return dest;
    }

    public Quaterniond rotationTo(double fromDirX, double fromDirY, double fromDirZ, double toDirX, double toDirY, double toDirZ) {
        this.x = fromDirY * toDirZ - fromDirZ * toDirY;
        this.y = fromDirZ * toDirX - fromDirX * toDirZ;
        this.z = fromDirX * toDirY - fromDirY * toDirX;
        this.w = Math.sqrt((fromDirX * fromDirX + fromDirY * fromDirY + fromDirZ * fromDirZ) * (toDirX * toDirX + toDirY * toDirY + toDirZ * toDirZ)) + (fromDirX * toDirX + fromDirY * toDirY + fromDirZ * toDirZ);
        double invNorm = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        if (Double.isInfinite(invNorm)) {
            this.x = toDirY;
            this.y = -toDirX;
            this.z = 0.0;
            this.w = 0.0;
            invNorm = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y));
            if (Double.isInfinite(invNorm)) {
                this.x = 0.0;
                this.y = toDirZ;
                this.z = -toDirY;
                this.w = 0.0;
                invNorm = (float)(1.0 / Math.sqrt(this.y * this.y + this.z * this.z));
            }
        }
        this.x *= invNorm;
        this.y *= invNorm;
        this.z *= invNorm;
        this.w *= invNorm;
        return this;
    }

    public Quaterniond rotationTo(Vector3dc fromDir, Vector3dc toDir) {
        return this.rotationTo(fromDir.x(), fromDir.y(), fromDir.z(), toDir.x(), toDir.y(), toDir.z());
    }

    public Quaterniond rotateTo(double fromDirX, double fromDirY, double fromDirZ, double toDirX, double toDirY, double toDirZ, Quaterniond dest) {
        double x = fromDirY * toDirZ - fromDirZ * toDirY;
        double y = fromDirZ * toDirX - fromDirX * toDirZ;
        double z = fromDirX * toDirY - fromDirY * toDirX;
        double w = Math.sqrt((fromDirX * fromDirX + fromDirY * fromDirY + fromDirZ * fromDirZ) * (toDirX * toDirX + toDirY * toDirY + toDirZ * toDirZ)) + (fromDirX * toDirX + fromDirY * toDirY + fromDirZ * toDirZ);
        double invNorm = 1.0 / Math.sqrt(x * x + y * y + z * z + w * w);
        if (Double.isInfinite(invNorm)) {
            x = toDirY;
            y = -toDirX;
            z = 0.0;
            w = 0.0;
            invNorm = (float)(1.0 / Math.sqrt(x * x + y * y));
            if (Double.isInfinite(invNorm)) {
                x = 0.0;
                y = toDirZ;
                z = -toDirY;
                w = 0.0;
                invNorm = (float)(1.0 / Math.sqrt(y * y + z * z));
            }
        }
        dest.set(this.w * (x *= invNorm) + this.x * (w *= invNorm) + this.y * (z *= invNorm) - this.z * (y *= invNorm), this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaterniond rotationAxis(AxisAngle4f axisAngle) {
        return this.rotationAxis(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Quaterniond rotationAxis(double angle, double axisX, double axisY, double axisZ) {
        double hangle = angle / 2.0;
        double sinAngle = Math.sin(hangle);
        double invVLength = 1.0 / Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        this.x = axisX * invVLength * sinAngle;
        this.y = axisY * invVLength * sinAngle;
        this.z = axisZ * invVLength * sinAngle;
        this.w = (float)Math.cosFromSin(sinAngle, hangle);
        return this;
    }

    public Quaterniond rotation(double angleX, double angleY, double angleZ) {
        double s;
        double thetaX = angleX * 0.5;
        double thetaY = angleY * 0.5;
        double thetaZ = angleZ * 0.5;
        double thetaMagSq = thetaX * thetaX + thetaY * thetaY + thetaZ * thetaZ;
        if (thetaMagSq * thetaMagSq / 24.0 < (double)1.0E-8f) {
            this.w = 1.0 - thetaMagSq / 2.0;
            s = 1.0 - thetaMagSq / 6.0;
        } else {
            double thetaMag = Math.sqrt(thetaMagSq);
            double sin = Math.sin(thetaMag);
            s = sin / thetaMag;
            this.w = Math.cosFromSin(sin, thetaMag);
        }
        this.x = thetaX * s;
        this.y = thetaY * s;
        this.z = thetaZ * s;
        return this;
    }

    public Quaterniond rotationX(double angle) {
        double cos;
        double sin = Math.sin(angle * 0.5);
        this.w = cos = Math.cosFromSin(sin, angle * 0.5);
        this.x = sin;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public Quaterniond rotationY(double angle) {
        double cos;
        double sin = Math.sin(angle * 0.5);
        this.w = cos = Math.cosFromSin(sin, angle * 0.5);
        this.x = 0.0;
        this.y = sin;
        this.z = 0.0;
        return this;
    }

    public Quaterniond rotationZ(double angle) {
        double cos;
        double sin = Math.sin(angle * 0.5);
        this.w = cos = Math.cosFromSin(sin, angle * 0.5);
        this.x = 0.0;
        this.y = 0.0;
        this.z = sin;
        return this;
    }

    public Quaterniond rotateTo(double fromDirX, double fromDirY, double fromDirZ, double toDirX, double toDirY, double toDirZ) {
        return this.rotateTo(fromDirX, fromDirY, fromDirZ, toDirX, toDirY, toDirZ, this);
    }

    public Quaterniond rotateTo(Vector3dc fromDir, Vector3dc toDir, Quaterniond dest) {
        return this.rotateTo(fromDir.x(), fromDir.y(), fromDir.z(), toDir.x(), toDir.y(), toDir.z(), dest);
    }

    public Quaterniond rotateTo(Vector3dc fromDir, Vector3dc toDir) {
        return this.rotateTo(fromDir.x(), fromDir.y(), fromDir.z(), toDir.x(), toDir.y(), toDir.z(), this);
    }

    public Quaterniond rotate(Vector3dc anglesXYZ, Quaterniond dest) {
        return this.rotate(anglesXYZ.x(), anglesXYZ.y(), anglesXYZ.z(), dest);
    }

    public Quaterniond rotate(Vector3dc anglesXYZ) {
        return this.rotate(anglesXYZ.x(), anglesXYZ.y(), anglesXYZ.z(), this);
    }

    public Quaterniond rotate(double angleX, double angleY, double angleZ) {
        return this.rotate(angleX, angleY, angleZ, this);
    }

    public Quaterniond rotate(double angleX, double angleY, double angleZ, Quaterniond dest) {
        double s;
        double dqW;
        double thetaX = angleX * 0.5;
        double thetaY = angleY * 0.5;
        double thetaZ = angleZ * 0.5;
        double thetaMagSq = thetaX * thetaX + thetaY * thetaY + thetaZ * thetaZ;
        if (thetaMagSq * thetaMagSq / 24.0 < (double)1.0E-8f) {
            dqW = 1.0 - thetaMagSq / 2.0;
            s = 1.0 - thetaMagSq / 6.0;
        } else {
            double thetaMag = Math.sqrt(thetaMagSq);
            double sin = Math.sin(thetaMag);
            s = sin / thetaMag;
            dqW = Math.cosFromSin(sin, thetaMag);
        }
        double dqX = thetaX * s;
        double dqY = thetaY * s;
        double dqZ = thetaZ * s;
        dest.set(this.w * dqX + this.x * dqW + this.y * dqZ - this.z * dqY, this.w * dqY - this.x * dqZ + this.y * dqW + this.z * dqX, this.w * dqZ + this.x * dqY - this.y * dqX + this.z * dqW, this.w * dqW - this.x * dqX - this.y * dqY - this.z * dqZ);
        return dest;
    }

    public Quaterniond rotateLocal(double angleX, double angleY, double angleZ) {
        return this.rotateLocal(angleX, angleY, angleZ, this);
    }

    public Quaterniond rotateLocal(double angleX, double angleY, double angleZ, Quaterniond dest) {
        double s;
        double dqW;
        double thetaX = angleX * 0.5;
        double thetaY = angleY * 0.5;
        double thetaZ = angleZ * 0.5;
        double thetaMagSq = thetaX * thetaX + thetaY * thetaY + thetaZ * thetaZ;
        if (thetaMagSq * thetaMagSq / 24.0 < 1.0E-8) {
            dqW = 1.0 - thetaMagSq * 0.5;
            s = 1.0 - thetaMagSq / 6.0;
        } else {
            double thetaMag = Math.sqrt(thetaMagSq);
            double sin = Math.sin(thetaMag);
            s = sin / thetaMag;
            dqW = Math.cosFromSin(sin, thetaMag);
        }
        double dqX = thetaX * s;
        double dqY = thetaY * s;
        double dqZ = thetaZ * s;
        dest.set(dqW * this.x + dqX * this.w + dqY * this.z - dqZ * this.y, dqW * this.y - dqX * this.z + dqY * this.w + dqZ * this.x, dqW * this.z + dqX * this.y - dqY * this.x + dqZ * this.w, dqW * this.w - dqX * this.x - dqY * this.y - dqZ * this.z);
        return dest;
    }

    public Quaterniond rotateX(double angle) {
        return this.rotateX(angle, this);
    }

    public Quaterniond rotateX(double angle, Quaterniond dest) {
        double sin = Math.sin(angle * 0.5);
        double cos = Math.cosFromSin(sin, angle * 0.5);
        dest.set(this.w * sin + this.x * cos, this.y * cos + this.z * sin, this.z * cos - this.y * sin, this.w * cos - this.x * sin);
        return dest;
    }

    public Quaterniond rotateY(double angle) {
        return this.rotateY(angle, this);
    }

    public Quaterniond rotateY(double angle, Quaterniond dest) {
        double sin = Math.sin(angle * 0.5);
        double cos = Math.cosFromSin(sin, angle * 0.5);
        dest.set(this.x * cos - this.z * sin, this.w * sin + this.y * cos, this.x * sin + this.z * cos, this.w * cos - this.y * sin);
        return dest;
    }

    public Quaterniond rotateZ(double angle) {
        return this.rotateZ(angle, this);
    }

    public Quaterniond rotateZ(double angle, Quaterniond dest) {
        double sin = Math.sin(angle * 0.5);
        double cos = Math.cosFromSin(sin, angle * 0.5);
        dest.set(this.x * cos + this.y * sin, this.y * cos - this.x * sin, this.w * sin + this.z * cos, this.w * cos - this.z * sin);
        return dest;
    }

    public Quaterniond rotateLocalX(double angle) {
        return this.rotateLocalX(angle, this);
    }

    public Quaterniond rotateLocalX(double angle, Quaterniond dest) {
        double hangle = angle * 0.5;
        double s = Math.sin(hangle);
        double c = Math.cosFromSin(s, hangle);
        dest.set(c * this.x + s * this.w, c * this.y - s * this.z, c * this.z + s * this.y, c * this.w - s * this.x);
        return dest;
    }

    public Quaterniond rotateLocalY(double angle) {
        return this.rotateLocalY(angle, this);
    }

    public Quaterniond rotateLocalY(double angle, Quaterniond dest) {
        double hangle = angle * 0.5;
        double s = Math.sin(hangle);
        double c = Math.cosFromSin(s, hangle);
        dest.set(c * this.x + s * this.z, c * this.y + s * this.w, c * this.z - s * this.x, c * this.w - s * this.y);
        return dest;
    }

    public Quaterniond rotateLocalZ(double angle) {
        return this.rotateLocalZ(angle, this);
    }

    public Quaterniond rotateLocalZ(double angle, Quaterniond dest) {
        double hangle = angle * 0.5;
        double s = Math.sin(hangle);
        double c = Math.cosFromSin(s, hangle);
        dest.set(c * this.x - s * this.y, c * this.y + s * this.x, c * this.z + s * this.w, c * this.w - s * this.z);
        return dest;
    }

    public Quaterniond rotateXYZ(double angleX, double angleY, double angleZ) {
        return this.rotateXYZ(angleX, angleY, angleZ, this);
    }

    public Quaterniond rotateXYZ(double angleX, double angleY, double angleZ, Quaterniond dest) {
        double sx = Math.sin(angleX * 0.5);
        double cx = Math.cosFromSin(sx, angleX * 0.5);
        double sy = Math.sin(angleY * 0.5);
        double cy = Math.cosFromSin(sy, angleY * 0.5);
        double sz = Math.sin(angleZ * 0.5);
        double cz = Math.cosFromSin(sz, angleZ * 0.5);
        double cycz = cy * cz;
        double sysz = sy * sz;
        double sycz = sy * cz;
        double cysz = cy * sz;
        double w = cx * cycz - sx * sysz;
        double x = sx * cycz + cx * sysz;
        double y = cx * sycz - sx * cysz;
        double z = cx * cysz + sx * sycz;
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaterniond rotateZYX(double angleZ, double angleY, double angleX) {
        return this.rotateZYX(angleZ, angleY, angleX, this);
    }

    public Quaterniond rotateZYX(double angleZ, double angleY, double angleX, Quaterniond dest) {
        double sx = Math.sin(angleX * 0.5);
        double cx = Math.cosFromSin(sx, angleX * 0.5);
        double sy = Math.sin(angleY * 0.5);
        double cy = Math.cosFromSin(sy, angleY * 0.5);
        double sz = Math.sin(angleZ * 0.5);
        double cz = Math.cosFromSin(sz, angleZ * 0.5);
        double cycz = cy * cz;
        double sysz = sy * sz;
        double sycz = sy * cz;
        double cysz = cy * sz;
        double w = cx * cycz + sx * sysz;
        double x = sx * cycz - cx * sysz;
        double y = cx * sycz + sx * cysz;
        double z = cx * cysz - sx * sycz;
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Quaterniond rotateYXZ(double angleZ, double angleY, double angleX) {
        return this.rotateYXZ(angleZ, angleY, angleX, this);
    }

    public Quaterniond rotateYXZ(double angleY, double angleX, double angleZ, Quaterniond dest) {
        double sx = Math.sin(angleX * 0.5);
        double cx = Math.cosFromSin(sx, angleX * 0.5);
        double sy = Math.sin(angleY * 0.5);
        double cy = Math.cosFromSin(sy, angleY * 0.5);
        double sz = Math.sin(angleZ * 0.5);
        double cz = Math.cosFromSin(sz, angleZ * 0.5);
        double yx = cy * sx;
        double yy = sy * cx;
        double yz = sy * sx;
        double yw = cy * cx;
        double x = yx * cz + yy * sz;
        double y = yy * cz - yx * sz;
        double z = yw * sz - yz * cz;
        double w = yw * cz + yz * sz;
        dest.set(this.w * x + this.x * w + this.y * z - this.z * y, this.w * y - this.x * z + this.y * w + this.z * x, this.w * z + this.x * y - this.y * x + this.z * w, this.w * w - this.x * x - this.y * y - this.z * z);
        return dest;
    }

    public Vector3d getEulerAnglesXYZ(Vector3d eulerAngles) {
        eulerAngles.x = Math.atan2(2.0 * (this.x * this.w - this.y * this.z), 1.0 - 2.0 * (this.x * this.x + this.y * this.y));
        eulerAngles.y = Math.asin(2.0 * (this.x * this.z + this.y * this.w));
        eulerAngles.z = Math.atan2(2.0 * (this.z * this.w - this.x * this.y), 1.0 - 2.0 * (this.y * this.y + this.z * this.z));
        return eulerAngles;
    }

    public Quaterniond rotateAxis(double angle, double axisX, double axisY, double axisZ, Quaterniond dest) {
        double hangle = angle / 2.0;
        double sinAngle = Math.sin(hangle);
        double invVLength = 1.0 / Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        double rx = axisX * invVLength * sinAngle;
        double ry = axisY * invVLength * sinAngle;
        double rz = axisZ * invVLength * sinAngle;
        double rw = Math.cosFromSin(sinAngle, hangle);
        dest.set(this.w * rx + this.x * rw + this.y * rz - this.z * ry, this.w * ry - this.x * rz + this.y * rw + this.z * rx, this.w * rz + this.x * ry - this.y * rx + this.z * rw, this.w * rw - this.x * rx - this.y * ry - this.z * rz);
        return dest;
    }

    public Quaterniond rotateAxis(double angle, Vector3dc axis, Quaterniond dest) {
        return this.rotateAxis(angle, axis.x(), axis.y(), axis.z(), dest);
    }

    public Quaterniond rotateAxis(double angle, Vector3dc axis) {
        return this.rotateAxis(angle, axis.x(), axis.y(), axis.z(), this);
    }

    public Quaterniond rotateAxis(double angle, double axisX, double axisY, double axisZ) {
        return this.rotateAxis(angle, axisX, axisY, axisZ, this);
    }

    public Vector3d positiveX(Vector3d dir) {
        double invNorm = 1.0 / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        double nx = -this.x * invNorm;
        double ny = -this.y * invNorm;
        double nz = -this.z * invNorm;
        double nw = this.w * invNorm;
        double dy = ny + ny;
        double dz = nz + nz;
        dir.x = -ny * dy - nz * dz + 1.0;
        dir.y = nx * dy + nw * dz;
        dir.z = nx * dz - nw * dy;
        return dir;
    }

    public Vector3d normalizedPositiveX(Vector3d dir) {
        double dy = this.y + this.y;
        double dz = this.z + this.z;
        dir.x = -this.y * dy - this.z * dz + 1.0;
        dir.y = this.x * dy - this.w * dz;
        dir.z = this.x * dz + this.w * dy;
        return dir;
    }

    public Vector3d positiveY(Vector3d dir) {
        double invNorm = 1.0 / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        double nx = -this.x * invNorm;
        double ny = -this.y * invNorm;
        double nz = -this.z * invNorm;
        double nw = this.w * invNorm;
        double dx = nx + nx;
        double dy = ny + ny;
        double dz = nz + nz;
        dir.x = nx * dy - nw * dz;
        dir.y = -nx * dx - nz * dz + 1.0;
        dir.z = ny * dz + nw * dx;
        return dir;
    }

    public Vector3d normalizedPositiveY(Vector3d dir) {
        double dx = this.x + this.x;
        double dy = this.y + this.y;
        double dz = this.z + this.z;
        dir.x = this.x * dy + this.w * dz;
        dir.y = -this.x * dx - this.z * dz + 1.0;
        dir.z = this.y * dz - this.w * dx;
        return dir;
    }

    public Vector3d positiveZ(Vector3d dir) {
        double invNorm = 1.0 / (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        double nx = -this.x * invNorm;
        double ny = -this.y * invNorm;
        double nz = -this.z * invNorm;
        double nw = this.w * invNorm;
        double dx = nx + nx;
        double dy = ny + ny;
        double dz = nz + nz;
        dir.x = nx * dz + nw * dy;
        dir.y = ny * dz - nw * dx;
        dir.z = -nx * dx - ny * dy + 1.0;
        return dir;
    }

    public Vector3d normalizedPositiveZ(Vector3d dir) {
        double dx = this.x + this.x;
        double dy = this.y + this.y;
        double dz = this.z + this.z;
        dir.x = this.x * dz - this.w * dy;
        dir.y = this.y * dz + this.w * dx;
        dir.z = -this.x * dx - this.y * dy + 1.0;
        return dir;
    }

    public Quaterniondc toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Quaterniondc {
        private final Quaterniondc delegate;

        Proxy(Quaterniondc delegate) {
            this.delegate = delegate;
        }

        public double x() {
            return this.delegate.x();
        }

        public double y() {
            return this.delegate.y();
        }

        public double z() {
            return this.delegate.z();
        }

        public double w() {
            return this.delegate.w();
        }

        public Quaterniond normalize(Quaterniond dest) {
            return this.delegate.normalize(dest);
        }

        public Quaterniond add(double x, double y, double z, double w, Quaterniond dest) {
            return this.delegate.add(x, y, z, w, dest);
        }

        public Quaterniond add(Quaterniondc q2, Quaterniond dest) {
            return this.delegate.add(q2, dest);
        }

        public double dot(Quaterniondc otherQuat) {
            return this.delegate.dot(otherQuat);
        }

        public double angle() {
            return this.delegate.angle();
        }

        public Matrix3d get(Matrix3d dest) {
            return this.delegate.get(dest);
        }

        public Matrix3f get(Matrix3f dest) {
            return this.delegate.get(dest);
        }

        public Matrix4d get(Matrix4d dest) {
            return this.delegate.get(dest);
        }

        public Matrix4f get(Matrix4f dest) {
            return this.delegate.get(dest);
        }

        public Quaterniond get(Quaterniond dest) {
            return this.delegate.get(dest);
        }

        public Quaterniond mul(Quaterniondc q, Quaterniond dest) {
            return this.delegate.mul(q, dest);
        }

        public Quaterniond mul(double qx, double qy, double qz, double qw, Quaterniond dest) {
            return this.delegate.mul(qx, qy, qz, qw, dest);
        }

        public Quaterniond premul(Quaterniondc q, Quaterniond dest) {
            return this.delegate.premul(q, dest);
        }

        public Quaterniond premul(double qx, double qy, double qz, double qw, Quaterniond dest) {
            return this.delegate.premul(qx, qy, qz, qw, dest);
        }

        public Vector3d transform(Vector3d vec) {
            return this.delegate.transform(vec);
        }

        public Vector4d transform(Vector4d vec) {
            return this.delegate.transform(vec);
        }

        public Vector3d transform(Vector3dc vec, Vector3d dest) {
            return this.delegate.transform(vec, dest);
        }

        public Vector3d transform(double x, double y, double z, Vector3d dest) {
            return this.delegate.transform(x, y, z, dest);
        }

        public Vector4d transform(Vector4dc vec, Vector4d dest) {
            return this.delegate.transform(vec, dest);
        }

        public Vector4d transform(double x, double y, double z, Vector4d dest) {
            return this.delegate.transform(x, y, z, dest);
        }

        public Quaterniond invert(Quaterniond dest) {
            return this.delegate.invert(dest);
        }

        public Quaterniond div(Quaterniondc b, Quaterniond dest) {
            return this.delegate.div(b, dest);
        }

        public Quaterniond conjugate(Quaterniond dest) {
            return this.delegate.conjugate(dest);
        }

        public double lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public Quaterniond slerp(Quaterniondc target, double alpha, Quaterniond dest) {
            return this.delegate.slerp(target, alpha, dest);
        }

        public Quaterniond scale(double factor, Quaterniond dest) {
            return this.delegate.scale(factor, dest);
        }

        public Quaterniond integrate(double dt, double vx, double vy, double vz, Quaterniond dest) {
            return this.delegate.integrate(dt, vx, vy, vz, dest);
        }

        public Quaterniond nlerp(Quaterniondc q, double factor, Quaterniond dest) {
            return this.delegate.nlerp(q, factor, dest);
        }

        public Quaterniond nlerpIterative(Quaterniondc q, double alpha, double dotThreshold, Quaterniond dest) {
            return this.delegate.nlerpIterative(q, alpha, dotThreshold, dest);
        }

        public Quaterniond lookAlong(Vector3dc dir, Vector3dc up, Quaterniond dest) {
            return this.delegate.lookAlong(dir, up, dest);
        }

        public Quaterniond lookAlong(double dirX, double dirY, double dirZ, double upX, double upY, double upZ, Quaterniond dest) {
            return this.delegate.lookAlong(dirX, dirY, dirZ, upX, upY, upZ, dest);
        }

        public Quaterniond difference(Quaterniondc other, Quaterniond dest) {
            return this.delegate.difference(other, dest);
        }

        public Quaterniond rotateTo(double fromDirX, double fromDirY, double fromDirZ, double toDirX, double toDirY, double toDirZ, Quaterniond dest) {
            return this.delegate.rotateTo(fromDirX, fromDirY, fromDirZ, toDirX, toDirY, toDirZ, dest);
        }

        public Quaterniond rotateTo(Vector3dc fromDir, Vector3dc toDir, Quaterniond dest) {
            return this.delegate.rotateTo(fromDir, toDir, dest);
        }

        public Quaterniond rotate(Vector3dc anglesXYZ, Quaterniond dest) {
            return this.delegate.rotate(anglesXYZ, dest);
        }

        public Quaterniond rotate(double angleX, double angleY, double angleZ, Quaterniond dest) {
            return this.delegate.rotate(angleX, angleY, angleZ, dest);
        }

        public Quaterniond rotateLocal(double angleX, double angleY, double angleZ, Quaterniond dest) {
            return this.delegate.rotateLocal(angleX, angleY, angleZ, dest);
        }

        public Quaterniond rotateX(double angle, Quaterniond dest) {
            return this.delegate.rotateX(angle, dest);
        }

        public Quaterniond rotateY(double angle, Quaterniond dest) {
            return this.delegate.rotateY(angle, dest);
        }

        public Quaterniond rotateZ(double angle, Quaterniond dest) {
            return this.delegate.rotateZ(angle, dest);
        }

        public Quaterniond rotateLocalX(double angle, Quaterniond dest) {
            return this.delegate.rotateLocalX(angle, dest);
        }

        public Quaterniond rotateLocalY(double angle, Quaterniond dest) {
            return this.delegate.rotateLocalY(angle, dest);
        }

        public Quaterniond rotateLocalZ(double angle, Quaterniond dest) {
            return this.delegate.rotateLocalZ(angle, dest);
        }

        public Quaterniond rotateXYZ(double angleX, double angleY, double angleZ, Quaterniond dest) {
            return this.delegate.rotateXYZ(angleX, angleY, angleZ, dest);
        }

        public Quaterniond rotateZYX(double angleZ, double angleY, double angleX, Quaterniond dest) {
            return this.delegate.rotateZYX(angleZ, angleY, angleX, dest);
        }

        public Quaterniond rotateYXZ(double angleY, double angleX, double angleZ, Quaterniond dest) {
            return this.delegate.rotateYXZ(angleY, angleX, angleZ, dest);
        }

        public Vector3d getEulerAnglesXYZ(Vector3d eulerAngles) {
            return this.delegate.getEulerAnglesXYZ(eulerAngles);
        }

        public Quaterniond rotateAxis(double angle, double axisX, double axisY, double axisZ, Quaterniond dest) {
            return this.delegate.rotateAxis(angle, axisX, axisY, axisZ, dest);
        }

        public Quaterniond rotateAxis(double angle, Vector3dc axis, Quaterniond dest) {
            return this.delegate.rotateAxis(angle, axis, dest);
        }

        public Vector3d positiveX(Vector3d dir) {
            return this.delegate.positiveX(dir);
        }

        public Vector3d normalizedPositiveX(Vector3d dir) {
            return this.delegate.normalizedPositiveX(dir);
        }

        public Vector3d positiveY(Vector3d dir) {
            return this.delegate.positiveY(dir);
        }

        public Vector3d normalizedPositiveY(Vector3d dir) {
            return this.delegate.normalizedPositiveY(dir);
        }

        public Vector3d positiveZ(Vector3d dir) {
            return this.delegate.positiveZ(dir);
        }

        public Vector3d normalizedPositiveZ(Vector3d dir) {
            return this.delegate.normalizedPositiveZ(dir);
        }
    }
}

