/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stb_vorbis_alloc")
public class STBVorbisAlloc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOC_BUFFER;
    public static final int ALLOC_BUFFER_LENGTH_IN_BYTES;

    STBVorbisAlloc(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBVorbisAlloc(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBVorbisAlloc.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer alloc_buffer() {
        return STBVorbisAlloc.nalloc_buffer(this.address());
    }

    public int alloc_buffer_length_in_bytes() {
        return STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address());
    }

    public STBVorbisAlloc alloc_buffer(@NativeType(value="char *") ByteBuffer value) {
        STBVorbisAlloc.nalloc_buffer(this.address(), value);
        return this;
    }

    public STBVorbisAlloc set(STBVorbisAlloc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static STBVorbisAlloc malloc() {
        return STBVorbisAlloc.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static STBVorbisAlloc calloc() {
        return STBVorbisAlloc.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static STBVorbisAlloc create() {
        return new STBVorbisAlloc(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBVorbisAlloc create(long address) {
        return address == 0L ? null : new STBVorbisAlloc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBVorbisAlloc.create(STBVorbisAlloc.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBVorbisAlloc.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBVorbisAlloc.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBVorbisAlloc mallocStack() {
        return STBVorbisAlloc.mallocStack(MemoryStack.stackGet());
    }

    public static STBVorbisAlloc callocStack() {
        return STBVorbisAlloc.callocStack(MemoryStack.stackGet());
    }

    public static STBVorbisAlloc mallocStack(MemoryStack stack) {
        return STBVorbisAlloc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBVorbisAlloc callocStack(MemoryStack stack) {
        return STBVorbisAlloc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBVorbisAlloc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBVorbisAlloc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBVorbisAlloc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBVorbisAlloc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nalloc_buffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)ALLOC_BUFFER)), (int)STBVorbisAlloc.nalloc_buffer_length_in_bytes(struct));
    }

    public static int nalloc_buffer_length_in_bytes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ALLOC_BUFFER_LENGTH_IN_BYTES));
    }

    public static void nalloc_buffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ALLOC_BUFFER), (long)MemoryUtil.memAddress((ByteBuffer)value));
        STBVorbisAlloc.nalloc_buffer_length_in_bytes(struct, value.remaining());
    }

    public static void nalloc_buffer_length_in_bytes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ALLOC_BUFFER_LENGTH_IN_BYTES), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ALLOC_BUFFER)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            STBVorbisAlloc.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = STBVorbisAlloc.__struct((Struct.Member[])new Struct.Member[]{STBVorbisAlloc.__member((int)POINTER_SIZE), STBVorbisAlloc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOC_BUFFER = layout.offsetof(0);
        ALLOC_BUFFER_LENGTH_IN_BYTES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<STBVorbisAlloc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBVorbisAlloc newInstance(long address) {
            return new STBVorbisAlloc(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char *")
        public ByteBuffer alloc_buffer() {
            return STBVorbisAlloc.nalloc_buffer(this.address());
        }

        public int alloc_buffer_length_in_bytes() {
            return STBVorbisAlloc.nalloc_buffer_length_in_bytes(this.address());
        }

        public Buffer alloc_buffer(@NativeType(value="char *") ByteBuffer value) {
            STBVorbisAlloc.nalloc_buffer(this.address(), value);
            return this;
        }
    }
}

