/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbtt_bakedchar")
public class STBTTBakedChar
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X0;
    public static final int Y0;
    public static final int X1;
    public static final int Y1;
    public static final int XOFF;
    public static final int YOFF;
    public static final int XADVANCE;

    STBTTBakedChar(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBTTBakedChar(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBTTBakedChar.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned short")
    public short x0() {
        return STBTTBakedChar.nx0(this.address());
    }

    @NativeType(value="unsigned short")
    public short y0() {
        return STBTTBakedChar.ny0(this.address());
    }

    @NativeType(value="unsigned short")
    public short x1() {
        return STBTTBakedChar.nx1(this.address());
    }

    @NativeType(value="unsigned short")
    public short y1() {
        return STBTTBakedChar.ny1(this.address());
    }

    public float xoff() {
        return STBTTBakedChar.nxoff(this.address());
    }

    public float yoff() {
        return STBTTBakedChar.nyoff(this.address());
    }

    public float xadvance() {
        return STBTTBakedChar.nxadvance(this.address());
    }

    public static STBTTBakedChar malloc() {
        return STBTTBakedChar.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static STBTTBakedChar calloc() {
        return STBTTBakedChar.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static STBTTBakedChar create() {
        return new STBTTBakedChar(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBTTBakedChar create(long address) {
        return address == 0L ? null : new STBTTBakedChar(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBTTBakedChar.create(STBTTBakedChar.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBTTBakedChar.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBTTBakedChar.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBTTBakedChar mallocStack() {
        return STBTTBakedChar.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTBakedChar callocStack() {
        return STBTTBakedChar.callocStack(MemoryStack.stackGet());
    }

    public static STBTTBakedChar mallocStack(MemoryStack stack) {
        return STBTTBakedChar.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTBakedChar callocStack(MemoryStack stack) {
        return STBTTBakedChar.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTBakedChar.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTBakedChar.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBTTBakedChar.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBTTBakedChar.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nx0(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)X0));
    }

    public static short ny0(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)Y0));
    }

    public static short nx1(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)X1));
    }

    public static short ny1(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)Y1));
    }

    public static float nxoff(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)XOFF));
    }

    public static float nyoff(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)YOFF));
    }

    public static float nxadvance(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)XADVANCE));
    }

    static {
        Struct.Layout layout = STBTTBakedChar.__struct((Struct.Member[])new Struct.Member[]{STBTTBakedChar.__member((int)2), STBTTBakedChar.__member((int)2), STBTTBakedChar.__member((int)2), STBTTBakedChar.__member((int)2), STBTTBakedChar.__member((int)4), STBTTBakedChar.__member((int)4), STBTTBakedChar.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X0 = layout.offsetof(0);
        Y0 = layout.offsetof(1);
        X1 = layout.offsetof(2);
        Y1 = layout.offsetof(3);
        XOFF = layout.offsetof(4);
        YOFF = layout.offsetof(5);
        XADVANCE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<STBTTBakedChar, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBTTBakedChar newInstance(long address) {
            return new STBTTBakedChar(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned short")
        public short x0() {
            return STBTTBakedChar.nx0(this.address());
        }

        @NativeType(value="unsigned short")
        public short y0() {
            return STBTTBakedChar.ny0(this.address());
        }

        @NativeType(value="unsigned short")
        public short x1() {
            return STBTTBakedChar.nx1(this.address());
        }

        @NativeType(value="unsigned short")
        public short y1() {
            return STBTTBakedChar.ny1(this.address());
        }

        public float xoff() {
            return STBTTBakedChar.nxoff(this.address());
        }

        public float yoff() {
            return STBTTBakedChar.nyoff(this.address());
        }

        public float xadvance() {
            return STBTTBakedChar.nxadvance(this.address());
        }
    }
}

