/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbrp_rect")
public class STBRPRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int W;
    public static final int H;
    public static final int X;
    public static final int Y;
    public static final int WAS_PACKED;

    STBRPRect(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBRPRect(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBRPRect.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int id() {
        return STBRPRect.nid(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short w() {
        return STBRPRect.nw(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short h() {
        return STBRPRect.nh(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short x() {
        return STBRPRect.nx(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short y() {
        return STBRPRect.ny(this.address());
    }

    public int was_packed() {
        return STBRPRect.nwas_packed(this.address());
    }

    public STBRPRect id(int value) {
        STBRPRect.nid(this.address(), value);
        return this;
    }

    public STBRPRect w(@NativeType(value="stbrp_coord") short value) {
        STBRPRect.nw(this.address(), value);
        return this;
    }

    public STBRPRect h(@NativeType(value="stbrp_coord") short value) {
        STBRPRect.nh(this.address(), value);
        return this;
    }

    public STBRPRect x(@NativeType(value="stbrp_coord") short value) {
        STBRPRect.nx(this.address(), value);
        return this;
    }

    public STBRPRect y(@NativeType(value="stbrp_coord") short value) {
        STBRPRect.ny(this.address(), value);
        return this;
    }

    public STBRPRect was_packed(int value) {
        STBRPRect.nwas_packed(this.address(), value);
        return this;
    }

    public STBRPRect set(int id, short w, short h, short x, short y, int was_packed) {
        this.id(id);
        this.w(w);
        this.h(h);
        this.x(x);
        this.y(y);
        this.was_packed(was_packed);
        return this;
    }

    public STBRPRect set(STBRPRect src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static STBRPRect malloc() {
        return STBRPRect.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static STBRPRect calloc() {
        return STBRPRect.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static STBRPRect create() {
        return new STBRPRect(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBRPRect create(long address) {
        return address == 0L ? null : new STBRPRect(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBRPRect.create(STBRPRect.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBRPRect.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBRPRect.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBRPRect mallocStack() {
        return STBRPRect.mallocStack(MemoryStack.stackGet());
    }

    public static STBRPRect callocStack() {
        return STBRPRect.callocStack(MemoryStack.stackGet());
    }

    public static STBRPRect mallocStack(MemoryStack stack) {
        return STBRPRect.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBRPRect callocStack(MemoryStack stack) {
        return STBRPRect.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBRPRect.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBRPRect.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBRPRect.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBRPRect.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nid(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ID));
    }

    public static short nw(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)W));
    }

    public static short nh(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)H));
    }

    public static short nx(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)X));
    }

    public static short ny(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)Y));
    }

    public static int nwas_packed(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WAS_PACKED));
    }

    public static void nid(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ID), (int)value);
    }

    public static void nw(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)W), (short)value);
    }

    public static void nh(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)H), (short)value);
    }

    public static void nx(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)X), (short)value);
    }

    public static void ny(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)Y), (short)value);
    }

    public static void nwas_packed(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WAS_PACKED), (int)value);
    }

    static {
        Struct.Layout layout = STBRPRect.__struct((Struct.Member[])new Struct.Member[]{STBRPRect.__member((int)4), STBRPRect.__member((int)2), STBRPRect.__member((int)2), STBRPRect.__member((int)2), STBRPRect.__member((int)2), STBRPRect.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        W = layout.offsetof(1);
        H = layout.offsetof(2);
        X = layout.offsetof(3);
        Y = layout.offsetof(4);
        WAS_PACKED = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<STBRPRect, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBRPRect newInstance(long address) {
            return new STBRPRect(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public int id() {
            return STBRPRect.nid(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short w() {
            return STBRPRect.nw(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short h() {
            return STBRPRect.nh(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short x() {
            return STBRPRect.nx(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short y() {
            return STBRPRect.ny(this.address());
        }

        public int was_packed() {
            return STBRPRect.nwas_packed(this.address());
        }

        public Buffer id(int value) {
            STBRPRect.nid(this.address(), value);
            return this;
        }

        public Buffer w(@NativeType(value="stbrp_coord") short value) {
            STBRPRect.nw(this.address(), value);
            return this;
        }

        public Buffer h(@NativeType(value="stbrp_coord") short value) {
            STBRPRect.nh(this.address(), value);
            return this;
        }

        public Buffer x(@NativeType(value="stbrp_coord") short value) {
            STBRPRect.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="stbrp_coord") short value) {
            STBRPRect.ny(this.address(), value);
            return this;
        }

        public Buffer was_packed(int value) {
            STBRPRect.nwas_packed(this.address(), value);
            return this;
        }
    }
}

