/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbrp_node")
public class STBRPNode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    STBRPNode(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBRPNode(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBRPNode.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public static STBRPNode malloc() {
        return STBRPNode.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static STBRPNode calloc() {
        return STBRPNode.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static STBRPNode create() {
        return new STBRPNode(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBRPNode create(long address) {
        return address == 0L ? null : new STBRPNode(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBRPNode.create(STBRPNode.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBRPNode.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBRPNode.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBRPNode mallocStack() {
        return STBRPNode.mallocStack(MemoryStack.stackGet());
    }

    public static STBRPNode callocStack() {
        return STBRPNode.callocStack(MemoryStack.stackGet());
    }

    public static STBRPNode mallocStack(MemoryStack stack) {
        return STBRPNode.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBRPNode callocStack(MemoryStack stack) {
        return STBRPNode.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBRPNode.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBRPNode.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBRPNode.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBRPNode.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        LibSTB.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = STBRPNode.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<STBRPNode, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBRPNode newInstance(long address) {
            return new STBRPNode(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }
    }
}

