/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbrp_context")
public class STBRPContext
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    STBRPContext(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBRPContext(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBRPContext.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public static STBRPContext malloc() {
        return STBRPContext.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static STBRPContext calloc() {
        return STBRPContext.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static STBRPContext create() {
        return new STBRPContext(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBRPContext create(long address) {
        return address == 0L ? null : new STBRPContext(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBRPContext.create(STBRPContext.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBRPContext.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBRPContext.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBRPContext mallocStack() {
        return STBRPContext.mallocStack(MemoryStack.stackGet());
    }

    public static STBRPContext callocStack() {
        return STBRPContext.callocStack(MemoryStack.stackGet());
    }

    public static STBRPContext mallocStack(MemoryStack stack) {
        return STBRPContext.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBRPContext callocStack(MemoryStack stack) {
        return STBRPContext.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBRPContext.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBRPContext.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBRPContext.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBRPContext.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        LibSTB.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = STBRPContext.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<STBRPContext, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBRPContext newInstance(long address) {
            return new STBRPContext(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }
    }
}

