/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBIEOFCallback;
import org.lwjgl.stb.STBIEOFCallbackI;
import org.lwjgl.stb.STBIReadCallback;
import org.lwjgl.stb.STBIReadCallbackI;
import org.lwjgl.stb.STBISkipCallback;
import org.lwjgl.stb.STBISkipCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbi_io_callbacks")
public class STBIIOCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int READ;
    public static final int SKIP;
    public static final int EOF;

    STBIIOCallbacks(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBIIOCallbacks(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBIIOCallbacks.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="stbi_io_callbacks.read")
    public STBIReadCallback read() {
        return STBIIOCallbacks.nread(this.address());
    }

    @NativeType(value="stbi_io_callbacks.skip")
    public STBISkipCallback skip() {
        return STBIIOCallbacks.nskip(this.address());
    }

    @NativeType(value="stbi_io_callbacks.eof")
    public STBIEOFCallback eof() {
        return STBIIOCallbacks.neof(this.address());
    }

    public STBIIOCallbacks read(@NativeType(value="stbi_io_callbacks.read") STBIReadCallbackI value) {
        STBIIOCallbacks.nread(this.address(), value);
        return this;
    }

    public STBIIOCallbacks skip(@NativeType(value="stbi_io_callbacks.skip") STBISkipCallbackI value) {
        STBIIOCallbacks.nskip(this.address(), value);
        return this;
    }

    public STBIIOCallbacks eof(@NativeType(value="stbi_io_callbacks.eof") STBIEOFCallbackI value) {
        STBIIOCallbacks.neof(this.address(), value);
        return this;
    }

    public STBIIOCallbacks set(STBIReadCallbackI read, STBISkipCallbackI skip, STBIEOFCallbackI eof) {
        this.read(read);
        this.skip(skip);
        this.eof(eof);
        return this;
    }

    public STBIIOCallbacks set(STBIIOCallbacks src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static STBIIOCallbacks malloc() {
        return STBIIOCallbacks.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static STBIIOCallbacks calloc() {
        return STBIIOCallbacks.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static STBIIOCallbacks create() {
        return new STBIIOCallbacks(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBIIOCallbacks create(long address) {
        return address == 0L ? null : new STBIIOCallbacks(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBIIOCallbacks.create(STBIIOCallbacks.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBIIOCallbacks.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBIIOCallbacks.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBIIOCallbacks mallocStack() {
        return STBIIOCallbacks.mallocStack(MemoryStack.stackGet());
    }

    public static STBIIOCallbacks callocStack() {
        return STBIIOCallbacks.callocStack(MemoryStack.stackGet());
    }

    public static STBIIOCallbacks mallocStack(MemoryStack stack) {
        return STBIIOCallbacks.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBIIOCallbacks callocStack(MemoryStack stack) {
        return STBIIOCallbacks.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBIIOCallbacks.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBIIOCallbacks.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBIIOCallbacks.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBIIOCallbacks.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static STBIReadCallback nread(long struct) {
        return STBIReadCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)READ)));
    }

    public static STBISkipCallback nskip(long struct) {
        return STBISkipCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)SKIP)));
    }

    public static STBIEOFCallback neof(long struct) {
        return STBIEOFCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)EOF)));
    }

    public static void nread(long struct, STBIReadCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)READ), (long)value.address());
    }

    public static void nskip(long struct, STBISkipCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SKIP), (long)value.address());
    }

    public static void neof(long struct, STBIEOFCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)EOF), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)READ)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SKIP)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)EOF)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            STBIIOCallbacks.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = STBIIOCallbacks.__struct((Struct.Member[])new Struct.Member[]{STBIIOCallbacks.__member((int)POINTER_SIZE), STBIIOCallbacks.__member((int)POINTER_SIZE), STBIIOCallbacks.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        READ = layout.offsetof(0);
        SKIP = layout.offsetof(1);
        EOF = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<STBIIOCallbacks, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBIIOCallbacks newInstance(long address) {
            return new STBIIOCallbacks(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="stbi_io_callbacks.read")
        public STBIReadCallback read() {
            return STBIIOCallbacks.nread(this.address());
        }

        @NativeType(value="stbi_io_callbacks.skip")
        public STBISkipCallback skip() {
            return STBIIOCallbacks.nskip(this.address());
        }

        @NativeType(value="stbi_io_callbacks.eof")
        public STBIEOFCallback eof() {
            return STBIIOCallbacks.neof(this.address());
        }

        public Buffer read(@NativeType(value="stbi_io_callbacks.read") STBIReadCallbackI value) {
            STBIIOCallbacks.nread(this.address(), value);
            return this;
        }

        public Buffer skip(@NativeType(value="stbi_io_callbacks.skip") STBISkipCallbackI value) {
            STBIIOCallbacks.nskip(this.address(), value);
            return this;
        }

        public Buffer eof(@NativeType(value="stbi_io_callbacks.eof") STBIEOFCallbackI value) {
            STBIIOCallbacks.neof(this.address(), value);
            return this;
        }
    }
}

