/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class ARBMultiBind {
    protected ARBMultiBind() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBindBuffersBase, caps.glBindBuffersRange, caps.glBindTextures, caps.glBindSamplers, caps.glBindImageTextures, caps.glBindVertexBuffers});
    }

    public static native void nglBindBuffersBase(int var0, int var1, int var2, long var3);

    public static void glBindBuffersBase(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") IntBuffer buffers) {
        ARBMultiBind.nglBindBuffersBase(target, first, Checks.remainingSafe((Buffer)buffers), MemoryUtil.memAddressSafe((IntBuffer)buffers));
    }

    public static native void nglBindBuffersRange(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glBindBuffersRange(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") IntBuffer buffers, @NativeType(value="const GLintptr *") PointerBuffer offsets, @NativeType(value="const GLsizeiptr *") PointerBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)offsets, (int)Checks.remainingSafe((Buffer)buffers));
            Checks.checkSafe((CustomBuffer)sizes, (int)Checks.remainingSafe((Buffer)buffers));
        }
        ARBMultiBind.nglBindBuffersRange(target, first, Checks.remainingSafe((Buffer)buffers), MemoryUtil.memAddressSafe((IntBuffer)buffers), MemoryUtil.memAddressSafe((Pointer)offsets), MemoryUtil.memAddressSafe((Pointer)sizes));
    }

    public static native void nglBindTextures(int var0, int var1, long var2);

    public static void glBindTextures(@NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") IntBuffer textures) {
        ARBMultiBind.nglBindTextures(first, Checks.remainingSafe((Buffer)textures), MemoryUtil.memAddressSafe((IntBuffer)textures));
    }

    public static native void nglBindSamplers(int var0, int var1, long var2);

    public static void glBindSamplers(@NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") IntBuffer samplers) {
        ARBMultiBind.nglBindSamplers(first, Checks.remainingSafe((Buffer)samplers), MemoryUtil.memAddressSafe((IntBuffer)samplers));
    }

    public static native void nglBindImageTextures(int var0, int var1, long var2);

    public static void glBindImageTextures(@NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") IntBuffer textures) {
        ARBMultiBind.nglBindImageTextures(first, Checks.remainingSafe((Buffer)textures), MemoryUtil.memAddressSafe((IntBuffer)textures));
    }

    public static native void nglBindVertexBuffers(int var0, int var1, long var2, long var4, long var6);

    public static void glBindVertexBuffers(@NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") IntBuffer buffers, @NativeType(value="const GLintptr *") PointerBuffer offsets, @NativeType(value="const GLsizei *") IntBuffer strides) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)offsets, (int)Checks.remainingSafe((Buffer)buffers));
            Checks.checkSafe((Buffer)strides, (int)Checks.remainingSafe((Buffer)buffers));
        }
        ARBMultiBind.nglBindVertexBuffers(first, Checks.remainingSafe((Buffer)buffers), MemoryUtil.memAddressSafe((IntBuffer)buffers), MemoryUtil.memAddressSafe((Pointer)offsets), MemoryUtil.memAddressSafe((IntBuffer)strides));
    }

    public static void glBindBuffersBase(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") int[] buffers) {
        long __functionAddress = GL.getICD().glBindBuffersBase;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)first, (int)Checks.lengthSafe((int[])buffers), (int[])buffers);
    }

    public static void glBindBuffersRange(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") int[] buffers, @NativeType(value="const GLintptr *") PointerBuffer offsets, @NativeType(value="const GLsizeiptr *") PointerBuffer sizes) {
        long __functionAddress = GL.getICD().glBindBuffersRange;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((CustomBuffer)offsets, (int)Checks.lengthSafe((int[])buffers));
            Checks.checkSafe((CustomBuffer)sizes, (int)Checks.lengthSafe((int[])buffers));
        }
        JNI.callPPPV((long)__functionAddress, (int)target, (int)first, (int)Checks.lengthSafe((int[])buffers), (int[])buffers, (long)MemoryUtil.memAddressSafe((Pointer)offsets), (long)MemoryUtil.memAddressSafe((Pointer)sizes));
    }

    public static void glBindTextures(@NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") int[] textures) {
        long __functionAddress = GL.getICD().glBindTextures;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)Checks.lengthSafe((int[])textures), (int[])textures);
    }

    public static void glBindSamplers(@NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") int[] samplers) {
        long __functionAddress = GL.getICD().glBindSamplers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)Checks.lengthSafe((int[])samplers), (int[])samplers);
    }

    public static void glBindImageTextures(@NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") int[] textures) {
        long __functionAddress = GL.getICD().glBindImageTextures;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)first, (int)Checks.lengthSafe((int[])textures), (int[])textures);
    }

    public static void glBindVertexBuffers(@NativeType(value="GLuint") int first, @NativeType(value="const GLuint *") int[] buffers, @NativeType(value="const GLintptr *") PointerBuffer offsets, @NativeType(value="const GLsizei *") int[] strides) {
        long __functionAddress = GL.getICD().glBindVertexBuffers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((CustomBuffer)offsets, (int)Checks.lengthSafe((int[])buffers));
            Checks.checkSafe((int[])strides, (int)Checks.lengthSafe((int[])buffers));
        }
        JNI.callPPPV((long)__functionAddress, (int)first, (int)Checks.lengthSafe((int[])buffers), (int[])buffers, (long)MemoryUtil.memAddressSafe((Pointer)offsets), (int[])strides);
    }

    static {
        GL.initialize();
    }
}

