/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTCapture {
    public static final int ALC_CAPTURE_DEVICE_SPECIFIER = 784;
    public static final int ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER = 785;
    public static final int ALC_CAPTURE_SAMPLES = 786;

    protected EXTCapture() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.alcCaptureOpenDevice, caps.alcCaptureCloseDevice, caps.alcCaptureStart, caps.alcCaptureStop, caps.alcCaptureSamples});
    }

    public static long nalcCaptureOpenDevice(long deviceName, int frequency, int format, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureOpenDevice;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePP((long)__functionAddress, (long)deviceName, (int)frequency, (int)format, (int)samples);
    }

    @NativeType(value="ALCdevice *")
    public static long alcCaptureOpenDevice(@NativeType(value="const ALCchar *") ByteBuffer deviceName, @NativeType(value="ALCuint") int frequency, @NativeType(value="ALCenum") int format, @NativeType(value="ALCsizei") int samples) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)deviceName);
        }
        return EXTCapture.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe((ByteBuffer)deviceName), frequency, format, samples);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ALCdevice *")
    public static long alcCaptureOpenDevice(@NativeType(value="const ALCchar *") CharSequence deviceName, @NativeType(value="ALCuint") int frequency, @NativeType(value="ALCenum") int format, @NativeType(value="ALCsizei") int samples) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer deviceNameEncoded = stack.UTF8(deviceName);
            long l = EXTCapture.nalcCaptureOpenDevice(MemoryUtil.memAddressSafe((ByteBuffer)deviceNameEncoded), frequency, format, samples);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="ALCboolean")
    public static boolean alcCaptureCloseDevice(@NativeType(value="ALCdevice *") long device) {
        long __functionAddress = ALC.getICD().alcCaptureCloseDevice;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.invokePZ((long)__functionAddress, (long)device);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureStart(@NativeType(value="ALCdevice *") long device) {
        long __functionAddress = ALC.getICD().alcCaptureStart;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        JNI.invokePV((long)__functionAddress, (long)device);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureStop(@NativeType(value="ALCdevice *") long device) {
        long __functionAddress = ALC.getICD().alcCaptureStop;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        JNI.invokePV((long)__functionAddress, (long)device);
    }

    public static void nalcCaptureSamples(long device, long buffer, int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        JNI.invokePPV((long)__functionAddress, (long)device, (long)buffer, (int)samples);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureSamples(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCvoid *") ByteBuffer buffer, @NativeType(value="ALCsizei") int samples) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress((ByteBuffer)buffer), samples);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureSamples(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCvoid *") ShortBuffer buffer, @NativeType(value="ALCsizei") int samples) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress((ShortBuffer)buffer), samples);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureSamples(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCvoid *") IntBuffer buffer, @NativeType(value="ALCsizei") int samples) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress((IntBuffer)buffer), samples);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureSamples(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCvoid *") FloatBuffer buffer, @NativeType(value="ALCsizei") int samples) {
        EXTCapture.nalcCaptureSamples(device, MemoryUtil.memAddress((FloatBuffer)buffer), samples);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureSamples(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCvoid *") short[] buffer, @NativeType(value="ALCsizei") int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        JNI.invokePPV((long)__functionAddress, (long)device, (short[])buffer, (int)samples);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureSamples(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCvoid *") int[] buffer, @NativeType(value="ALCsizei") int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        JNI.invokePPV((long)__functionAddress, (long)device, (int[])buffer, (int)samples);
    }

    @NativeType(value="ALCvoid")
    public static void alcCaptureSamples(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCvoid *") float[] buffer, @NativeType(value="ALCsizei") int samples) {
        long __functionAddress = ALC.getICD().alcCaptureSamples;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        JNI.invokePPV((long)__functionAddress, (long)device, (float[])buffer, (int)samples);
    }
}

