/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.ThreadLocalUtil;

public final class AL {
    private static FunctionProvider functionProvider;
    private static ALCapabilities processCaps;
    private static final ThreadLocal<ALCapabilities> capabilitiesTLS;
    private static ICD icd;

    private AL() {
    }

    static void init() {
        functionProvider = new FunctionProvider(){
            private final long alGetProcAddress = ALC.getFunctionProvider().getFunctionAddress((CharSequence)"alGetProcAddress");

            public long getFunctionAddress(ByteBuffer functionName) {
                long address = JNI.invokePP((long)this.alGetProcAddress, (long)MemoryUtil.memAddress((ByteBuffer)functionName));
                if (address == 0L && Checks.DEBUG_FUNCTIONS) {
                    APIUtil.apiLog((CharSequence)("Failed to locate address for AL function " + MemoryUtil.memASCII((ByteBuffer)functionName)));
                }
                return address;
            }
        };
    }

    static void destroy() {
        if (functionProvider == null) {
            return;
        }
        AL.setCurrentProcess(null);
        functionProvider = null;
    }

    public static void setCurrentProcess(ALCapabilities caps) {
        processCaps = caps;
        capabilitiesTLS.set(null);
        icd.set(caps);
    }

    public static void setCurrentThread(ALCapabilities caps) {
        capabilitiesTLS.set(caps);
        icd.set(caps);
    }

    public static ALCapabilities getCapabilities() {
        ALCapabilities caps = capabilitiesTLS.get();
        if (caps == null) {
            caps = processCaps;
        }
        return AL.checkCapabilities(caps);
    }

    private static ALCapabilities checkCapabilities(ALCapabilities caps) {
        if (Checks.CHECKS && caps == null) {
            throw new IllegalStateException("No ALCapabilities instance set for the current thread or process. Possible solutions:\n\ta) Call AL.createCapabilities() after making a context current.\n\tb) Call AL.setCurrentProcess() or AL.setCurrentThread() if an ALCapabilities instance already exists.");
        }
        return caps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALCapabilities createCapabilities(ALCCapabilities alcCaps) {
        ALCapabilities aLCapabilities;
        ALCapabilities caps = null;
        try {
            long GetString = functionProvider.getFunctionAddress((CharSequence)"alGetString");
            long GetError = functionProvider.getFunctionAddress((CharSequence)"alGetError");
            long IsExtensionPresent = functionProvider.getFunctionAddress((CharSequence)"alIsExtensionPresent");
            if (GetString == 0L || GetError == 0L || IsExtensionPresent == 0L) {
                throw new IllegalStateException("Core OpenAL functions could not be found. Make sure that the OpenAL library has been loaded correctly.");
            }
            long versionString = JNI.invokeP((long)GetString, (int)45058);
            if (versionString == 0L || JNI.invokeI((long)GetError) != 0) {
                throw new IllegalStateException("There is no OpenAL context current in the current thread or process.");
            }
            APIUtil.APIVersion apiVersion = APIUtil.apiParseVersion((String)MemoryUtil.memASCII((long)versionString));
            int majorVersion = apiVersion.major;
            int minorVersion = apiVersion.minor;
            int[][] AL_VERSIONS = new int[][]{{0, 1}};
            HashSet<String> supportedExtensions = new HashSet<String>(32);
            for (int major = 1; major <= AL_VERSIONS.length; ++major) {
                int[] minors;
                for (int minor : minors = AL_VERSIONS[major - 1]) {
                    if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                    supportedExtensions.add("OpenAL" + Integer.toString(major) + Integer.toString(minor));
                }
            }
            String extensionsString = MemoryUtil.memASCII((long)JNI.invokeP((long)GetString, (int)45060));
            if (extensionsString != null) {
                MemoryStack stack = MemoryStack.stackGet();
                StringTokenizer tokenizer = new StringTokenizer(extensionsString);
                while (tokenizer.hasMoreTokens()) {
                    String extName = tokenizer.nextToken();
                    stack.push();
                    try {
                        if (!JNI.invokePZ((long)IsExtensionPresent, (long)MemoryUtil.memAddress((ByteBuffer)stack.ASCII((CharSequence)extName, true)))) continue;
                        supportedExtensions.add(extName);
                    }
                    finally {
                        stack.pop();
                    }
                }
            }
            if (alcCaps.ALC_EXT_EFX) {
                supportedExtensions.add("ALC_EXT_EFX");
            }
            aLCapabilities = caps = new ALCapabilities(functionProvider, supportedExtensions);
        }
        catch (Throwable throwable) {
            if (alcCaps.ALC_EXT_thread_local_context && EXTThreadLocalContext.alcGetThreadContext() != 0L) {
                AL.setCurrentThread(caps);
            } else {
                AL.setCurrentProcess(caps);
            }
            throw throwable;
        }
        if (alcCaps.ALC_EXT_thread_local_context && EXTThreadLocalContext.alcGetThreadContext() != 0L) {
            AL.setCurrentThread(caps);
        } else {
            AL.setCurrentProcess(caps);
        }
        return aLCapabilities;
    }

    static ALCapabilities getICD() {
        return icd.get();
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        icd = new ICDStatic();
    }

    private static class ICDStatic
    implements ICD {
        private static ALCapabilities tempCaps;

        private ICDStatic() {
        }

        @Override
        public void set(ALCapabilities caps) {
            if (caps != null && tempCaps != null && !ThreadLocalUtil.compareCapabilities((PointerBuffer)ICDStatic.tempCaps.addresses, (PointerBuffer)caps.addresses)) {
                APIUtil.apiLog((CharSequence)"[WARNING] Incompatible context detected. Falling back to thread/process lookup for AL contexts.");
                icd = AL::getCapabilities;
                return;
            }
            if (tempCaps == null) {
                tempCaps = caps;
            }
        }

        @Override
        public ALCapabilities get() {
            return WriteOnce.caps;
        }

        static /* synthetic */ ALCapabilities access$300() {
            return tempCaps;
        }

        private static final class WriteOnce {
            private static final ALCapabilities caps = ICDStatic.access$300();

            private WriteOnce() {
            }

            static {
                if (caps == null) {
                    throw new IllegalStateException("No ALCapabilities instance has been set");
                }
            }
        }
    }

    private static interface ICD {
        default public void set(ALCapabilities caps) {
        }

        public ALCapabilities get();
    }
}

