package me.aflak.bluetoothterminal;



import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.text.InputFilter;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.Toast;

import java.util.ArrayList;

import static android.text.TextUtils.isEmpty;

public class SelectCaptor extends AppCompatActivity{

    ArrayList<LinearLayout> alll;
    ArrayList<Spinner> als;
    EditText saisie;

    int nbCapteurs;

    String[] listeType = {"Aucun", "Température", "Vitesse", "Humidité", "Luminosité"};
    String[] listeDuree = {"0", "100", "200", "300", "400", "500"};


    Spinner duree;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.selectcaptor);

        saisie = (EditText) findViewById(R.id.nb);

        alll = new ArrayList<LinearLayout>();
        als = new ArrayList<Spinner>();

        alll.add((LinearLayout) findViewById(R.id.capt0));
        alll.add((LinearLayout) findViewById(R.id.capt1));
        alll.add((LinearLayout) findViewById(R.id.capt2));
        alll.add((LinearLayout) findViewById(R.id.capt3));

        als.add((Spinner) findViewById(R.id.spin0));
        als.add((Spinner) findViewById(R.id.spin1));
        als.add((Spinner) findViewById(R.id.spin2));
        als.add((Spinner) findViewById(R.id.spin3));

        for(Spinner s : als) {
            ArrayAdapter<String> adp1 = new ArrayAdapter<String>(this,
                    android.R.layout.simple_list_item_1, listeType);
            adp1.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
            s.setAdapter(adp1);
        }

        duree = (Spinner) findViewById(R.id.spinDuree);
        genSpinDuree();
    }

    private void genSpinDuree() {

        ArrayAdapter<String> adp1 = new ArrayAdapter<String>(this,
                android.R.layout.simple_list_item_1, listeDuree);
        adp1.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        duree.setAdapter(adp1);

    }

    public void onClickAffiche(View view) {

        for(LinearLayout l : alll)
            l.setVisibility(View.INVISIBLE);

        if(!isEmpty(saisie.getText())) {

            nbCapteurs = Integer.parseInt(saisie.getText().toString());

            if(nbCapteurs <= 0) nbCapteurs = 1;
            if(nbCapteurs > 4) nbCapteurs = 4;

            for(int i = 0; i < nbCapteurs; i++)
                alll.get(i).setVisibility(View.VISIBLE);

            ((Button) findViewById(R.id.valider)).setVisibility(View.VISIBLE);
        }

    }


    public void onClickNext(View view) {

        Intent intent = new Intent(SelectCaptor.this, Chat.class);

        Bundle extra = getIntent().getExtras();

        intent.putExtra("pos", extra.getInt("pos"));

        ArrayList<String> envoi = new ArrayList<String>();

        for(int i = 0; i < nbCapteurs; i++) {
            envoi.add(als.get(i).getSelectedItem().toString());
        }

        String timer;

        //convertie la vitesse en lettre correspondant
        switch (duree.getSelectedItem().toString()) {
            case "0":   timer = "A";
                break;
            case "100": timer = "B";
                break;
            case "200": timer = "C";
                break;
            case "300": timer = "D";
                break;
            case "400": timer = "E";
                break;
            case "500": timer = "F";
                break;
            default:    timer = "C";
        }


        intent.putExtra("capteurs", envoi);
        intent.putExtra("nbCapteurs", nbCapteurs);
        intent.putExtra("timer", timer);

        startActivity(intent);

    }
}