package me.aflak.bluetoothterminal;

import java.io.Serializable;


public class Capteur implements Serializable{

    private static int nbCaptAct = 0;
    private int numero;
    private int valAct;
    private String type;



    public Capteur() {
        this(0, "None");
    }

    public Capteur(int valAct) {
        this(valAct, "None");
    }

    public Capteur (String type) {
        this(0, type);
    }

    public Capteur(int valAct, String type) {
        this.numero = this.nbCaptAct;
        this.valAct = valAct;
        this.type = type;

        nbCaptAct++;
    }


    /**GETTER AND SETTER**/

    public static int getNbCaptAct() {
        return nbCaptAct;
    }

    public int getNumero() {
        return numero;
    }

    public int getValAct() {
        return valAct;

    }

    public void setValAct(int valAct) {
        this.valAct = valAct;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String setUnit() {
        switch (type){
            case "Température" : return "°";
            case "Vitesse" : return "m/s";
            case "Humidité" : return "%";
            case "Luminosité" : return "lx";
            default : return "";
        }
    }

    @Override
    public String toString() {
        return numero + " : " + valAct + " " + setUnit() + " (" + type +")";
    }
}
