package servlet;

import javax.servlet.*;
import javax.servlet.http.*;
import beans.Annuaire;
import beans.Personne;
import java.io.IOException;
import java.util.Collection;

public class GetListePersonnes extends HttpServlet {
  public void service(HttpServletRequest requete, HttpServletResponse reponse) throws ServletException, IOException {
    // récupérer la liste des personnes
    Annuaire annuaire = Annuaire.getInstance();
    Collection<Personne> personnes = annuaire.getPersonnes();

    // stocker la liste des personnes pour la vue suivante
    requete.setAttribute("liste", personnes);

    // passer la main à la vue suivante
    RequestDispatcher rd = requete.getRequestDispatcher("/listePersonnes.jsp");
    rd.forward(requete, reponse);
  }
}
